<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\BusinessCentral\Model\Erp;

use Ecomero\BusinessCentral\Helper\Settings;
use Ecomero\BusinessCentral\Model\BusinessCentralAdapter;
use Ecomero\BusinessCentral\Model\BusinessCentralAPI;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Erp\ErpInvoiceInterface;
use Ecomero\ErpCore\Model\Order\ResponseFactory as OrderResponseFactory;
use Magento\Framework\Stdlib\ArrayManager;

class BcInvoice extends BusinessCentralAdapter implements ErpInvoiceInterface
{
    public function __construct(
        BusinessCentralAPI $api,
        Settings $settings,
        Capability $capability,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        OrderResponseFactory $orderResponseFactory,
        ArrayManager $arrayManager
    ) {
        parent::__construct(
            $api,
            $settings,
            $capability,
            $storeManager,
            $orderResponseFactory,
            $arrayManager
        );
    }

    public function getInvoiceFromOrder(
        string $orderNo
    ): array {
        $result = [];
        $bcInvoices = $this->api->callStandardApi("salesInvoices?\$filter=orderNumber eq '{$orderNo}'&\$expand=salesInvoiceLines");

        foreach ($bcInvoices as $bcInvoice) {
            $invoice = [];
            $invoice['number'] = $this->arrayManager->get('number', $bcInvoice);

            $shippingAmount = 0;
            foreach ($this->arrayManager->get('salesInvoiceLines', $bcInvoice) as $bcInvoiceLine) {
                $invoiceLine = [];

                $amount = $this->arrayManager->get('amountIncludingTax', $bcInvoiceLine);
                $itemId = $this->arrayManager->get('itemId', $bcInvoiceLine);

                $invoiceLine['qty'] = $this->arrayManager->get('quantity', $bcInvoiceLine);
                $invoiceLine['sku'] = $this->arrayManager->get('lineDetails/number', $bcInvoiceLine);
                $invoiceLine['amount'] = $amount;
                $invoice['invoiceItems'][] = $invoiceLine;

                if ($this->settings->isShippingChargeItem(
                    $this->getWebsite(),
                    $itemId
                )) {
                    $shippingAmount += $amount;
                }
            }
            $invoice['shippingFee'] = $shippingAmount;
            $result[] = $invoice;
        }

        return $result;
    }
}
