<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\BusinessCentral\Model\Config\Source;

use Ecomero\BusinessCentral\Helper\Settings;
use Ecomero\BusinessCentral\Model\Erp\BcOrder;
use Magento\Framework\Stdlib\ArrayManager;
use Psr\Log\LoggerInterface;

class DimensionList implements \Magento\Framework\Data\OptionSourceInterface
{
    protected $bcOrderApi;
    protected $settings;
    protected $logger;
    protected $arrayManager;

    public function __construct(
        BcOrder $bcOrderApi,
        Settings $settings,
        LoggerInterface $logger,
        ArrayManager $arrayManager
    ) {
        $this->bcOrderApi = $bcOrderApi;
        $this->settings = $settings;
        $this->logger = $logger;
        $this->arrayManager = $arrayManager;
    }

    public function toOptionArray(): array
    {
        $ret = [];
        $ret[] = [
            'value' => '', //$this->settings->getDimensions(),
            'label' => 'NO CONNECTION WITH BUSINESS CENTRAL',
        ];

        try {
            $arr = [];
            $dimensions = $this->bcOrderApi->getDimensions();
            foreach ($dimensions as $dimension) {
                $arr[$dimension['code']] = $dimension['displayName'];
            }

            $ret = [];
            foreach ($arr as $key => $value) {
                $ret[] = [
                    'value' => $key,
                    'label' => $value,
                ];
            }
        } catch (\Laminas\Http\Exception\RuntimeException $exception) {
            $this->logger->debug($exception->getMessage());
        } catch (\Magento\Framework\Exception\LocalizedException $exception) {
            $this->logger->debug($exception->getMessage());
        } catch (\RuntimeException $exception) {
            $this->logger->debug($exception->getMessage());
        }

        return $ret;
    }
}
