<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\BusinessCentral\Model;

use Ecomero\BusinessCentral\Helper\Settings;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Erp\ErpAdapter;
use Ecomero\ErpCore\Model\Order\ResponseFactory as OrderResponseFactory;
use Magento\Framework\Stdlib\ArrayManager;

class BusinessCentralAdapter extends ErpAdapter
{
    public const ERP_NAME = 'BusinessCentral';
    protected $api;
    protected $settings;
    protected $capability;
    protected $orderResponseFactory;
    protected $arrayManager;

    public function __construct(
        BusinessCentralAPI $api,
        Settings $settings,
        Capability $capability,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        OrderResponseFactory $orderResponseFactory,
        ArrayManager $arrayManager
    ) {
        parent::__construct($storeManager);

        $this->api = $api;
        $this->settings = $settings;
        $this->capability = $capability;
        $this->orderResponseFactory = $orderResponseFactory;
        $this->arrayManager = $arrayManager;

        $this->capability->setName(self::ERP_NAME);
        $this->capability->setCapability(Capability::PRODUCT_IMPORT, true);
        $this->capability->setCapability(Capability::PRODUCT_PICTURE_EXPORT, true);
        $this->capability->setCapability(Capability::ORDER_EXPORT, true);
        $this->capability->setCapability(Capability::ORDER_IMPORT, true);
        $this->capability->setCapability(Capability::CREDIT_MEMO_EXPORT, true);
        $this->capability->setCapability(Capability::INVOICE_IMPORT, true);
        $this->capability->setCapability(Capability::SHIPMENT_IMPORT, true);
        $this->capability->setCapability(Capability::RETURN_IMPORT, true);
        $this->capability->setCapability(Capability::COMPANY_IMPORT, true);
        $this->capability->setCapability(Capability::PRICE_IMPORT, true);
    }

    public function isErpEnabled(): string
    {
        if ($this->settings->isEnabled($this->getWebsite())) {
            return self::ERP_NAME;
        }

        return '';
    }

    public function getCapabilities(): array
    {
        $result[] = $this->capability;

        return $result;
    }
}
