<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\BusinessCentral\Model\Erp;

use Ecomero\BusinessCentral\Helper\Settings;
use Ecomero\BusinessCentral\Model\BusinessCentralAdapter;
use Ecomero\BusinessCentral\Model\BusinessCentralAPI;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Erp\ErpCreditMemoInterface;
use Ecomero\ErpCore\Model\Order\ResponseFactory as OrderResponseFactory;
use Magento\Framework\Stdlib\ArrayManager;

class BcCreditMemo extends BusinessCentralAdapter implements ErpCreditMemoInterface
{
    public function __construct(
        BusinessCentralAPI $businessCentral,
        Settings $settings,
        Capability $capability,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        OrderResponseFactory $orderResponseFactory,
        ArrayManager $arrayManager
    ) {
        parent::__construct(
            $businessCentral,
            $settings,
            $capability,
            $storeManager,
            $orderResponseFactory,
            $arrayManager
        );
    }

    public function createCreditMemo(
        string $creditMemoDate,
        string $orderNumber,
        ?string $invoiceNumber,
        string $customerNumber,
        string $currencyCode
    ): object {
        $rc = $this->businessCentral->createCreditMemo(
            $creditMemoDate,
            $orderNumber,
            $customerNumber,
            $this->settings->getSalesPerson($this->getWebsite()),
            $currencyCode
        );

        if ($rc['id']) {
            if ($invoiceNumber) {
                $this->businessCentral->addCreditMemoComment(
                    $rc['id'],
                    'Credit for invoice : '.$invoiceNumber
                );
            } else {
                $this->businessCentral->addCreditMemoComment(
                    $rc['id'],
                    'Credit for order : '.$orderNumber
                );
            }
        }

        return (object) $rc;
    }

    public function addCreditMemoItem(
        string $creditMemoId,
        string $bcItemId,
        float $price,
        float $qtyOrdered,
        string $vatCode,
        float $discountAmount,
        float $discountPercent
    ): void {
        $this->businessCentral->addCreditMemoItem(
            $creditMemoId,
            $bcItemId,
            $price,
            $qtyOrdered,
            $vatCode,
            $discountAmount,
            $discountPercent
        );
    }

    public function addCreditMemoCharge(
        string $creditMemoId,
        string $chargingSKU,
        float $price,
        float $qtyOrdered,
        string $vatCode,
        string $invoiceNo,
        int $numOrderLines
    ): void {
        $this->businessCentral->addCreditMemoCharge(
            $creditMemoId,
            $chargingSKU,
            $price,
            $qtyOrdered,
            $vatCode,
            $invoiceNo,
            $numOrderLines
        );
    }

    public function postCreditMemo(string $creditMemoId): void
    {
        $this->businessCentral->postCreditMemo(
            $creditMemoId
        );
    }
}
