<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\BusinessCentral\Model\Erp;

use Ecomero\BusinessCentral\Helper\Settings;
use Ecomero\BusinessCentral\Model\BusinessCentralAdapter;
use Ecomero\BusinessCentral\Model\BusinessCentralAPI;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Erp\ErpCreditMemoInterface;
use Ecomero\ErpCore\Model\Order\ResponseFactory as OrderResponseFactory;
use Magento\Framework\Stdlib\ArrayManager;

class BcCreditMemo extends BusinessCentralAdapter implements ErpCreditMemoInterface
{
    public function __construct(
        BusinessCentralAPI $api,
        Settings $settings,
        Capability $capability,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        OrderResponseFactory $orderResponseFactory,
        ArrayManager $arrayManager
    ) {
        parent::__construct(
            $api,
            $settings,
            $capability,
            $storeManager,
            $orderResponseFactory,
            $arrayManager
        );
    }

    public function createCreditMemo(
        string $creditMemoDate,
        string $orderNumber,
        ?string $invoiceNumber,
        string $customerNumber,
        string $currencyCode
    ): object {
        $payload = json_encode(['creditMemoDate' => $creditMemoDate,
            'externalDocumentNumber' => $orderNumber,
            // 'invoiceNumber' => $invoiceNumber,
            'customerNumber' => $customerNumber,
            'salesperson' => $this->settings->getSalesPerson($this->getWebsite()),
            'currencyCode' => $currencyCode, ]);

        $rc = $this->api->callStandardApi('salesCreditMemos', \Laminas\Http\Request::METHOD_POST, $payload);

        if ($rc['id']) {
            if ($invoiceNumber) {
                $this->addCreditMemoComment(
                    $rc['id'],
                    'Credit for invoice : '.$invoiceNumber
                );
            } else {
                $this->addCreditMemoComment(
                    $rc['id'],
                    'Credit for order : '.$orderNumber
                );
            }
        }

        return (object) $rc;
    }

    public function addCreditMemoItem(
        string $creditMemoId,
        string $bcItemId,
        float $price,
        float $qtyOrdered,
        string $vatCode,
        float $discountAmount,
        float $discountPercent,
        ?string $locationId
    ): void {
        $payload = json_encode(['itemId' => $bcItemId,
            'lineType' => 'Item',
            'quantity' => ((float) $qtyOrdered),
            'unitPrice' => ((float) $price),
            'discountAmount' => ((float) $discountAmount),
            'discountPercent' => ((float) $discountPercent),
            'taxCode' => $vatCode,
            'locationId' => $locationId, ]);

        $this->api->callStandardApi('salesCreditMemos('.$creditMemoId.')/salesCreditMemoLines', \Laminas\Http\Request::METHOD_POST, $payload);
    }

    public function postCreditMemo(string $creditMemoId): void
    {
        $this->api->callStandardApi('salesCreditMemos('.$creditMemoId.')/Microsoft.NAV.post', \Laminas\Http\Request::METHOD_POST, '', true);
    }

    private function addCreditMemoComment(
        string $creditMemoId,
        string $comment
    ): array {
        $payload = json_encode(['lineType' => 'Comment',
            'description' => $comment, ]);

        return $this->api->callStandardApi('salesCreditMemos('.$creditMemoId.')/salesCreditMemoLines', \Laminas\Http\Request::METHOD_POST, $payload);
    }
}
