<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\BusinessCentral\Model\Config\Source;

use Ecomero\BusinessCentral\Helper\Settings;
use Ecomero\BusinessCentral\Model\Erp\BcCatalog;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Stdlib\ArrayManager;
use Psr\Log\LoggerInterface;

class PriceList implements \Magento\Framework\Data\OptionSourceInterface
{
    protected $bcCatalogApi;
    protected $settings;
    protected $logger;
    protected $arrayManager;
    protected $optionArray;

    public function __construct(
        BcCatalog $bcCatalogApi,
        Settings $settings,
        LoggerInterface $logger,
        ArrayManager $arrayManager,
        RequestInterface $request
    ) {
        $this->bcCatalogApi = $bcCatalogApi;
        $this->settings = $settings;
        $this->logger = $logger;
        $this->arrayManager = $arrayManager;

        $websiteId = $request->getParam('website');
        if (null === $websiteId) {
            $websiteId = 0;
        }
        $this->bcCatalogApi->setWebsite((int) $websiteId);
    }

    public function toOptionArray(): array
    {
        if ($this->optionArray) {
            return $this->optionArray;
        }
        $ret = [];
        $ret[] = [
            'value' => $this->settings->getDefaultPriceList($this->bcCatalogApi->getWebsite()),
            'label' => 'NO CONNECTION WITH BUSINESS CENTRAL',
        ];

        try {
            $arr = [];
            $priceLists = $this->bcCatalogApi->getSalesPriceLists();
            foreach ($priceLists as $priceList) {
                $arr[$priceList['code']] = $priceList['description'].' ('.$priceList['code'].')';
            }

            $ret = [];
            foreach ($arr as $key => $value) {
                $ret[] = [
                    'value' => $key,
                    'label' => $value,
                ];
            }
        } catch (\Laminas\Http\Exception\RuntimeException $exception) {
            $this->logger->debug($exception->getMessage());
        } catch (\Magento\Framework\Exception\LocalizedException $exception) {
            $this->logger->debug($exception->getMessage());
        } catch (\RuntimeException $exception) {
            $this->logger->debug($exception->getMessage());
        }

        $this->optionArray = $ret;

        return $this->optionArray;
    }
}
