<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\EcomNext\Model\Erp;

use Ecomero\EcomNext\Model\EcomNextAdapter;
use Ecomero\EcomNext\Model\EcomNextAPI;
use Ecomero\ErpCore\Helper\Settings;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Erp\ErpCustomerInterface;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Store\Model\StoreManagerInterface;

class Customer extends EcomNextAdapter implements ErpCustomerInterface
{
    public function __construct(
        EcomNextAPI $api,
        Settings $settings,
        Capability $capability,
        ArrayManager $arrayManager,
        StoreManagerInterface $storeManager
    ) {
        parent::__construct(
            $api,
            $settings,
            $capability,
            $arrayManager,
            $storeManager
        );
    }

    public function getCompanyList(): array
    {
        return $this->api->post([
            'command' => 'company',
        ]);
    }

    public function getCustomerCategories(): array
    {
        return [];
    }

    public function getCustomerDistricts(): array
    {
        return [];
    }

    public function getCustomerFromEmail(
        string $email
    ): array {
        $rc = [];
        $result = $this->api->post([
            'command' => 'customer',
            'email' => $email,
        ]);

        // If the name is combined, then Split into first/last
        if (array_key_exists('name', $result) && !array_key_exists('first_name', $result)) {
            $parts = explode(' ', $result['name']);
            if (array_key_exists(0, $parts)) {
                $result['first_name'] = $parts[0];
            }
            if (array_key_exists(1, $parts)) {
                $result['last_name'] = $parts[1];
            }
        }

        $rc[] = $result;

        return $rc;
    }

    public function createCustomer(
        ?string $company,
        ?string $firstName,
        ?string $lastName,
        ?string $street,
        ?string $city,
        ?string $postCode,
        ?string $email,
        ?string $phone,
        ?string $country,
        ?string $region
    ): array {
        throw new \Exception('Not implemented');
    }
}
