<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\EcomNext\Model\Erp;

use Ecomero\EcomNext\Model\EcomNextAdapter;
use Ecomero\EcomNext\Model\EcomNextAPI;
use Ecomero\ErpCore\Helper\Settings;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Erp\ErpShippingInterface;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Store\Model\StoreManagerInterface;

class Shipping extends EcomNextAdapter implements ErpShippingInterface
{
    protected $itemListCache = [];

    public function __construct(
        EcomNextAPI $api,
        Settings $settings,
        Capability $capability,
        ArrayManager $arrayManager,
        StoreManagerInterface $storeManager
    ) {
        parent::__construct(
            $api,
            $settings,
            $capability,
            $arrayManager,
            $storeManager,
        );
    }

    public function getTermsOfDeliveries(): array
    {
        return [];
    }

    public function getWayOfDeliveries(): array
    {
        return [];
    }

    public function getWayOfDelivery(string $carrier, string $method): string
    {
        return '';
    }

    public function getShippingAgents(): array
    {
        return [];
    }

    public function getShippment(string $orderNo): array
    {
        $rc = $this->api->post([
            'command' => 'shipment-getbyid',
            'order-id' => $orderNo,
        ]);
        $shipments = [];
        $shippingNo = '';
        foreach ($rc['docs'] as $dbRow) {
            if ($shippingNo != $dbRow['shippingNo']) {
                $shippingNo = $dbRow['shippingNo'];
                $shipment = $this->initShipping($dbRow);
            }
            foreach ($dbRow['items'] as $item) {
                $shipment['items'][] = $item;
            }

            $shipments[$shippingNo] = $shipment;
        }

        return $shipments;
    }

    private function initShipping(array $dbRow)
    {
        return [
            'id' => $dbRow['shippingNo'],
            'shippingNo' => $dbRow['shippingNo'],
            'invoiceNo' => '',
            'shippingAgent' => $dbRow['shippingAgent'],
            'service' => '',
            'sentDate' => $dbRow['shipmentDate'],
            'trackingUrl' => '',
            'weight' => 0,
            'numPackages' => 1,
            'packages' => [
                0 => [
                    'trackingNumber' => $dbRow['packageTrackingNo'],
                    'weight' => 0,
                ],
            ],
            'items' => [],
        ];
    }
}
