<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Controller\Adminhtml\Synchronization;

use Magento\Backend\App\Action\Context;
use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\Result\JsonFactory;

class CommandControl extends \Magento\Backend\App\Action implements CsrfAwareActionInterface
{
    protected $resultJsonFactory;
    protected $catalogImport;
    protected $commands;

    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory,
        array $commands
    ) {
        parent::__construct($context);

        $this->resultJsonFactory = $resultJsonFactory;
        $this->commands = $commands;
    }

    public function createCsrfValidationException(RequestInterface $request): ?InvalidRequestException
    {
        return null;
    }

    public function validateForCsrf(RequestInterface $request): ?bool
    {
        return true;
    }

    public function execute(): object
    {
        $command = $this->_request->getParam('command');

        foreach ($this->commands as $c => $obj) {
            if ($c === $command) {
                $obj->executeFromWeb();
            }
        }

        $result = $this->resultJsonFactory->create();
        $result->setData(['status' => 'ok']);

        $result->setHeader('Cache-Control', 'no-cache', true);
        $result->setHeader('Access-Control-Allow-Headers', '*', true);
        $result->setHeader('Access-Control-Allow-Origin', '*', true);

        return $result;
    }
}
