<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\BusinessCentral\Helper;

use Magento\Config\Model\ResourceModel\Config\Data\CollectionFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Config\Storage\WriterInterface;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Encryption\EncryptorInterface;
use Magento\Framework\Serialize\Serializer\Json;

class Settings extends \Ecomero\ErpCore\Helper\Settings
{
    public function __construct(
        Context $context,
        EncryptorInterface $encryptor,
        WriterInterface $configWriter,
        CollectionFactory $configCollectionFactory,
        Json $unserializer
    ) {
        parent::__construct(
            $context,
            $encryptor,
            $configWriter,
            $configCollectionFactory,
            $unserializer
        );
    }

    // @return string
    public function getInstallation(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): string
    {
        $installation = $this->scopeConfig->getValue('erp_core/general/installation', $scope);

        return null === $installation ? '' : strtolower($installation);
    }

    // @return string
    public function getEnvironment(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): ?string
    {
        $env = $this->scopeConfig->getValue('erp_core/general/environment', $scope);
        return $env ? strtolower($env) : '';
    }

    // @return string
    public function getAPICompanyName(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): ?string
    {
        return $this->scopeConfig->getValue('erp_core/general/api_company', $scope);
    }

    // @return string
    public function getAuthMethod(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): ?string
    {
        return $this->scopeConfig->getValue('erp_core/general/authentication_method', $scope);
    }

    // @return string
    public function getUserName(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): ?string
    {
        return $this->scopeConfig->getValue('erp_core/general/user_name', $scope);
    }

    // @return string
    public function getClientId(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): ?string
    {
        return $this->scopeConfig->getValue('erp_core/general/client_id', $scope);
    }

    // @return string
    public function getSecret(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): ?string
    {
        $secret = $this->scopeConfig->getValue('erp_core/general/secret_value', $scope);

        return $this->encryptor->decrypt($secret);
    }

    // @return string
    public function getTenantId(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): ?string
    {
        return $this->scopeConfig->getValue('erp_core/general/tenant_id', $scope);
    }

    // @return string
    public function isDimensionsEnabled(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): bool
    {
        return $this->scopeConfig->isSetFlag('erp_core/order/enable_dimensions', $scope);
    }

    // @return string
    public function getDimension1(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): ?string
    {
        return $this->scopeConfig->getValue('erp_core/order/dimension_1', $scope);
    }

    // @return string
    public function getDimension2(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): ?string
    {
        return $this->scopeConfig->getValue('erp_core/order/dimension_2', $scope);
    }

    // @return string
    public function getDefaultPriceList(int $websiteId): ?string
    {
        return $this->scopeConfig->getValue('erp_core/catalog/price_list', 'website', $websiteId);
    }
}
