<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\BusinessCentral\Model\Erp;

use Ecomero\BusinessCentral\Helper\Settings;
use Ecomero\BusinessCentral\Model\BusinessCentralAdapter;
use Ecomero\BusinessCentral\Model\BusinessCentralAPI;
use Ecomero\ErpCore\Model\Attribute;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Erp\ErpCatalogInterface;
use Ecomero\ErpCore\Model\Order\ResponseFactory as OrderResponseFactory;
use Ecomero\ErpCore\Model\ResourceModel\Item\Collection;
use Magento\Framework\Stdlib\ArrayManager;

class BcCatalog extends BusinessCentralAdapter implements ErpCatalogInterface
{
    public function __construct(
        BusinessCentralAPI $businessCentral,
        Settings $settings,
        Capability $capability,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        OrderResponseFactory $orderResponseFactory,
        ArrayManager $arrayManager
    ) {
        parent::__construct(
            $businessCentral,
            $settings,
            $capability,
            $storeManager,
            $orderResponseFactory,
            $arrayManager
        );
    }

    public function getItemList(
        string $category,
        bool $force
    ): array {
        $result = [];
        $rc = $this->businessCentral->getItemList($category);
        foreach ($rc as $item) {
            $item['commonName'] = $item['description'];
            $result[] = $item;
        }

        return $result;
    }

    public function getItemPriceLists(): array
    {
        return [];
    }

    public function setItemImportCompleted(): void
    {
    }

    public function getItemPrices(
        string $category
    ): array {
        $result = [];
        $rc = $this->businessCentral->getItemPrices($category);
        foreach ($rc as $item) {
            $result[] = $item;
        }

        return $result;
    }

    public function getItemAttributes(
        string $category
    ): array {
        $result = [];
        $rc = $this->businessCentral->getItemAttributes($category);
        foreach ($rc as $item) {
            $result[] = $item;
        }

        return $result;
    }

    public function getNonInventoryItems(): array
    {
        return $this->businessCentral->getItemListNonInventory();
    }

    public function addPicture(
        string $itemId,
        string $imageUrl
    ): int {
        return $this->businessCentral->addPicture(
            $itemId,
            $imageUrl
        );
    }

    public function createCommonName(
        Collection $itemCollection
    ): bool {
        $commonNameAttributes = [];
        if ($this->settings->getCommonNameAttributes($this->getWebsite())) {
            $commonNameAttributes = explode(',', $this->settings->getCommonNameAttributes($this->getWebsite()));
        }

        $configurableAttributes = '';
        if ($this->settings->getConfigurableAttributes($this->getWebsite())) {
            $configurableAttributes = explode(',', $this->settings->getConfigurableAttributes($this->getWebsite()));
        }

        foreach ($itemCollection->getItems() as $item) {
            $item->commonName = '';
            foreach ($commonNameAttributes as $attribute) {
                $attribute = strtolower($attribute);
                if (key_exists($attribute, $item->attributes)) {
                    if ('' === $item->commonName) {
                        $item->commonName = $item->attributes[$attribute]->value;
                    } else {
                        $item->commonName = $item->commonName.'-'.$item->attributes[$attribute]->value;
                    }
                }
            }

            if (null !== $configurableAttributes && '' !== $configurableAttributes) {
                // Clear usedInConfiguration since it may have been set as deault to true by erp core
                foreach ($item->attributes as $key => $value) {
                    $item->attributes[$key]->usedInConfiguration = Attribute::NO;
                }

                // If attribute is a configurable product attribute, then set flag
                foreach ($configurableAttributes as $attribute) {
                    $attribute = strtolower($attribute);
                    if (key_exists($attribute, $item->attributes)) {
                        $item->attributes[$attribute]->usedInConfiguration = Attribute::YES;
                    }
                }
            }
        }

        return true;
    }
}
