<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\BusinessCentral\Model\Erp;

use Ecomero\BusinessCentral\Helper\Settings;
use Ecomero\BusinessCentral\Model\BusinessCentralAdapter;
use Ecomero\BusinessCentral\Model\BusinessCentralAPI;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Erp\ErpShippingInterface;
use Ecomero\ErpCore\Model\Order\ResponseFactory as OrderResponseFactory;
use Magento\Framework\Stdlib\ArrayManager;

class BcShipping extends BusinessCentralAdapter implements ErpShippingInterface
{
    private const PREFETCH_PAGE_SIZE = 100;

    private $prefetchedShippments = [];

    public function __construct(
        BusinessCentralAPI $api,
        Settings $settings,
        Capability $capability,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        OrderResponseFactory $orderResponseFactory,
        ArrayManager $arrayManager
    ) {
        parent::__construct(
            $api,
            $settings,
            $capability,
            $storeManager,
            $orderResponseFactory,
            $arrayManager
        );
    }

    public function getTermsOfDeliveries(): array
    {
        return [];
    }

    public function getWayOfDeliveries(): array
    {
        return [];
    }

    public function getWayOfDelivery(string $carrier, string $method): string
    {
        return '';
    }

    public function getShippingAgents(): array
    {
        $result = [];

        $url = 'shippingAgents';
        $rc = $this->api->callEcomeroApi($url);

        foreach ($rc as $item) {
            $result[] = $item;
        }

        return $result;
    }

    public function getLocations(): array
    {
        $result = [];

        $url = 'locations';
        $rc = $this->api->callStandardApi($url);

        foreach ($rc as $item) {
            $result[] = $item;
        }

        return $result;
    }

    public function preFetch(array $orderNumbers): void
    {
        $this->prefetchedShippments = [];

        $companyId = $this->api->getCompanyId();

        $chunks = array_chunk($orderNumbers, self::PREFETCH_PAGE_SIZE);
        foreach($chunks as $chunk) {
            $filter = '';
            foreach($chunk as $orderNumber) {
                $filter .= "magentoNo eq '{$orderNumber}' or "; 
            }
            if($filter) {
                $filter = substr($filter, 0, strlen($filter) - 4);
            }
    
            $payload = json_encode([
                'requests' => [
                    [
                        'method' => 'GET',
                        'id' => 'r1',
                        'url' => "companies({$companyId})/salesShipments?\$filter={$filter}&\$orderby=shippingNo",
                        'headers' => [
                            'Content-Type' => 'application/json',
                        ],
                    ],
                ],
            ]);
    
            $response = $this->api->callEcomeroApiBatch($payload);
            $bcShipments = $this->arrayManager->get('responses/0/body/value', $response);
            foreach($bcShipments as $bcShipment) {
                $orderNo = $this->arrayManager->get('magentoNo', $bcShipment);
                $this->prefetchedShippments[$orderNo][] = $bcShipment;
            }
        }
    }

    public function getShippment(
        string $orderNo
    ): array {

        $rc = $this->arrayManager->get($orderNo, $this->prefetchedShippments);
        if(!$rc) {
            return [];
        }

        $shipments = [];
        $shippingNo = '';
        foreach ($rc as $dbRow) {
            if ($shippingNo != $dbRow['shippingNo']) {
                $shippingNo = $dbRow['shippingNo'];
                $shipment = $this->initShipping($dbRow);
            }
            $shipment['items'][] = [
                'sku' => $dbRow['sku'],
                'qty' => $dbRow['qty'],
            ];

            $shipments[$shippingNo] = $shipment;
        }

        return $shipments;
    }

    private function initShipping(array $dbRow)
    {
        return [
            'id' => $dbRow['shippingNo'],
            'shippingNo' => $dbRow['shippingNo'],
            'invoiceNo' => '',
            'shippingAgent' => $dbRow['shippingAgent'],
            'service' => '',
            'sentDate' => $dbRow['shipmentDate'],
            'trackingUrl' => '',
            'weight' => 0,
            'numPackages' => 1,
            'packages' => [
                0 => [
                    'trackingNumber' => $dbRow['packageTrackingNo'],
                    'weight' => 0,
                ],
            ],
            'items' => [],
        ];
    }
}
