<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\BusinessCentral\Model\Erp;

use Ecomero\BusinessCentral\Helper\Settings;
use Ecomero\BusinessCentral\Model\BusinessCentralAdapter;
use Ecomero\BusinessCentral\Model\BusinessCentralAPI;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Erp\ErpRmaInterface;
use Ecomero\ErpCore\Model\Order\ResponseFactory as OrderResponseFactory;
use Magento\Framework\Stdlib\ArrayManager;

class BcRma extends BusinessCentralAdapter implements ErpRmaInterface
{
    public function __construct(
        BusinessCentralAPI $api,
        Settings $settings,
        Capability $capability,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        OrderResponseFactory $orderResponseFactory,
        ArrayManager $arrayManager
    ) {
        parent::__construct(
            $api,
            $settings,
            $capability,
            $storeManager,
            $orderResponseFactory,
            $arrayManager
        );
    }

    public function getReturns(): array
    {
        $result = [];
        $rc = $this->api->callWarehouseApi('returnItems?$filter=processed eq false');
        foreach ($rc as $item) {
            $result[] = $item;
        }

        return $result;
    }

    public function setReturnAsProcessed(string $id): void
    {
        $payload = json_encode(['processed' => true]);
        $this->api->callWarehouseApi("return(id={$id})", \Laminas\Http\Request::METHOD_PATCH, $payload);
    }
}
