<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\BusinessCentral\Helper;

use Magento\Config\Model\ResourceModel\Config\Data\CollectionFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Config\Storage\WriterInterface;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Encryption\EncryptorInterface;
use Magento\Framework\Serialize\Serializer\Json;

class Settings extends \Ecomero\ErpCore\Helper\Settings
{
    public function __construct(
        Context $context,
        EncryptorInterface $encryptor,
        WriterInterface $configWriter,
        CollectionFactory $configCollectionFactory,
        Json $unserializer
    ) {
        parent::__construct(
            $context,
            $encryptor,
            $configWriter,
            $configCollectionFactory,
            $unserializer
        );
    }

    // @return string
    public function getInstallation(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): string
    {
        $installation = $this->scopeConfig->getValue('erp_core/general/installation', $scope);

        return null === $installation ? '' : strtolower($installation);
    }

    // @return string
    public function getEnvironment(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): ?string
    {
        return strtolower($this->scopeConfig->getValue('erp_core/general/environment', $scope));
    }

    // @return string
    public function getAPICompanyName(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): ?string
    {
        return $this->scopeConfig->getValue('erp_core/general/api_company', $scope);
    }

    // @return string
    public function getUserName(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): ?string
    {
        return $this->scopeConfig->getValue('erp_core/general/user_name', $scope);
    }

    // @return string
    public function getTenantId(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): ?string
    {
        return $this->scopeConfig->getValue('erp_core/general/tenant_id', $scope);
    }

    // @return string
    public function getCommonNameAttributes(int $websiteId): ?string
    {
        return $this->scopeConfig->getValue('erp_core/catalog/product_attributes_common_name', 'website', $websiteId);
    }

    // @return string
    public function getConfigurableAttributes(int $websiteId): ?string
    {
        return $this->scopeConfig->getValue('erp_core/catalog/product_attributes_configurable', 'website', $websiteId);
    }
}
