<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\BusinessCentral\Model\Erp;

use Ecomero\BusinessCentral\Helper\Settings;
use Ecomero\BusinessCentral\Model\BusinessCentralAdapter;
use Ecomero\BusinessCentral\Model\BusinessCentralAPI;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Erp\ErpInvoiceInterface;
use Ecomero\ErpCore\Model\Order\ResponseFactory as OrderResponseFactory;
use Magento\Framework\Stdlib\ArrayManager;

class BcInvoice extends BusinessCentralAdapter implements ErpInvoiceInterface
{
    private const PREFETCH_PAGE_SIZE = 100;

    private $prefetchedInvoices = [];

    public function __construct(
        BusinessCentralAPI $api,
        Settings $settings,
        Capability $capability,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        OrderResponseFactory $orderResponseFactory,
        ArrayManager $arrayManager
    ) {
        parent::__construct(
            $api,
            $settings,
            $capability,
            $storeManager,
            $orderResponseFactory,
            $arrayManager
        );
    }

    public function preFetch(array $orderNumbers): void
    {
        $this->prefetchedInvoices = [];

        $companyId = $this->api->getCompanyId();

        $chunks = array_chunk($orderNumbers, self::PREFETCH_PAGE_SIZE);
        foreach($chunks as $chunk) {
            $filter = '';
            foreach($chunk as $orderNumber) {
                $filter .= "contains(externalDocumentNumber,'{$orderNumber}') or "; 
            }
            if($filter) {
                $filter = substr($filter, 0, strlen($filter) - 4);
            }
    
            $payload = json_encode([
                'requests' => [
                    [
                        'method' => 'GET',
                        'id' => 'r1',
                        'url' => "companies({$companyId})/salesInvoices?\$filter={$filter}&\$expand=salesInvoiceLines",
                        'headers' => [
                            'Content-Type' => 'application/json',
                        ],
                    ],
                ],
            ]);
    
            $response = $this->api->callStandardApiBatch($payload);
            $bcInvoices = $this->arrayManager->get('responses/0/body/value', $response);
            foreach($bcInvoices as $bcInvoice) {
                $orderNo = $this->arrayManager->get('externalDocumentNumber', $bcInvoice);
                $orderNo = substr($orderNo, 0, 10);
                $this->prefetchedInvoices[$orderNo][] = $bcInvoice;
            }
        }
    }

    public function getInvoiceFromOrder(
        string $orderNo
    ): array {
        $result = [];
        $bcInvoices = $this->arrayManager->get($orderNo, $this->prefetchedInvoices);
        if(!$bcInvoices) {
            return [];
        }

        foreach ($bcInvoices as $bcInvoice) {
            $invoice = [];
            $invoice['number'] = $this->arrayManager->get('number', $bcInvoice);

            $shippingAmount = 0;
            foreach ($this->arrayManager->get('salesInvoiceLines', $bcInvoice) as $bcInvoiceLine) {
                $invoiceLine = [];

                $amount = $this->arrayManager->get('amountIncludingTax', $bcInvoiceLine);

                $invoiceLine['qty'] = $this->arrayManager->get('quantity', $bcInvoiceLine);
                $invoiceLine['sku'] = $this->arrayManager->get('lineObjectNumber', $bcInvoiceLine);
                $invoiceLine['amount'] = $amount;
                $invoice['invoiceItems'][] = $invoiceLine;

                if ($this->settings->isShippingChargeItem(
                    $this->getWebsite(),
                    $invoiceLine['sku']
                )) {
                    $shippingAmount += $amount;
                }
            }
            $invoice['shippingFee'] = $shippingAmount;
            $result[] = $invoice;
        }

        return $result;
    }
}
