<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\BusinessCentral\Model\Erp;

use Ecomero\BusinessCentral\Helper\Settings;
use Ecomero\BusinessCentral\Model\BusinessCentralAdapter;
use Ecomero\BusinessCentral\Model\BusinessCentralAPI;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Erp\ErpOrderInterface;
use Ecomero\ErpCore\Model\Order\Response as OrderResponse;
use Ecomero\ErpCore\Model\Order\ResponseFactory as OrderResponseFactory;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Sales\Model\Order\Address;

class BcOrder extends BusinessCentralAdapter implements ErpOrderInterface
{
    public function __construct(
        BusinessCentralAPI $businessCentral,
        Settings $settings,
        Capability $capability,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        OrderResponseFactory $orderResponseFactory,
        ArrayManager $arrayManager
    ) {
        parent::__construct(
            $businessCentral,
            $settings,
            $capability,
            $storeManager,
            $orderResponseFactory,
            $arrayManager
        );
    }

    public function getSalesPersons(): array
    {
        $result = [];
        $rc = $this->businessCentral->getSalesPersons();
        foreach ($rc as $item) {
            $result[] = $item;
        }

        return $result;
    }

    public function getProfitCenters(): array
    {
        return [];
    }

    public function getDocumentFromExternalId(
        string $docType,
        string $magentoOrderId
    ): object {
        $tmpResult = [];
        $rc = $this->businessCentral->getDocumentFromExternalId($docType, $magentoOrderId);
        if (1 == count($rc)) {
            $tmpResult = $rc[0];

            return (object) $tmpResult;
        }

        return (object) [];
    }

    public function createDocument(
        string $docType,
        string $customerId,
        ?string $companyId,
        string $currency,
        Address $billingAddress,
        Address $shippingAddress,
        ?string $shippingAgent,
        ?string $shippingService,
        ?string $shippingPickupLocationId,
        string $magentoOrderId,
        string $salesPerson,
        ?string $profitCenter,
        ?string $termsOfDelivery,
        ?string $wayOfDelivery,
        ?string $customerCategory,
        ?string $customerDistrict
    ): OrderResponse {
        $rc = $this->businessCentral->createDocument(
            $docType,
            $customerId,
            $currency,
            $shippingAddress['firstname'].' '.$shippingAddress['lastname'],
            $shippingAddress['street'],
            $shippingAddress['city'],
            $shippingAddress['postcode'],
            $shippingAddress['telephone'],
            $shippingAddress['country_id'],
            $shippingAddress['region'],
            $shippingAgent,
            $shippingService,
            $shippingPickupLocationId,
            $magentoOrderId,
            $salesPerson
        );

        return $this->orderResponseFactory->create([
            'response' => [
                'customer_number' => $this->arrayManager->get('billCustomerId', $rc),
                'number' => $this->arrayManager->get('no', $rc),
                'id' => $this->arrayManager->get('id', $rc),
            ],
        ]);
    }

    public function updateDocument(
        string $docType,
        string $erpId,
        string $magentoOrderId
    ): OrderResponse {
        $rc = $this->businessCentral->updateDocument(
            $docType,
            $erpId,
            $magentoOrderId
        );

        return $this->orderResponseFactory->create([
            'response' => [
                'customer_number' => $this->arrayManager->get('customerNumber', $rc),
                'number' => $this->arrayManager->get('number', $rc),
                'id' => $this->arrayManager->get('id', $rc),
            ],
        ]);
    }

    public function addDocumentItem(
        string $docType,
        string $orderId,
        string $erpItemId,
        float $price,
        float $qtyOrdered,
        string $vatCode,
        float $discountAmount,
        float $discountPercent,
        ?string $comment
    ): void {
        $this->businessCentral->addDocumentItem(
            $docType,
            $orderId,
            $erpItemId,
            $price,
            $qtyOrdered,
            $vatCode,
            $discountAmount,
            $discountPercent
        );

        if ($comment) {
            $comment = str_replace("\n", ' - ', $comment);
            $this->businessCentral->addDocumentComment(
                $docType,
                $orderId,
                $comment
            );
        }
    }

    public function addChargeItem(
        string $docType,
        string $orderId,
        string $chargingSKU,
        float $price,
        float $qtyOrdered,
        string $vatCode,
        string $invoiceNo,
        int $numOrderLines
    ): void {
        $this->businessCentral->addChargeItem(
            $docType,
            $orderId,
            $chargingSKU,
            $price,
            $qtyOrdered,
            $vatCode,
            $invoiceNo,
            $numOrderLines
        );
    }

    public function postOrder(string $salesOrderId): void
    {
        $this->businessCentral->postOrder(
            $salesOrderId
        );
    }
}
