<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\EcomNext\Model;

use Ecomero\ErpCore\Helper\Settings;
use Ecomero\ErpCore\Model\Capability;
use Magento\Framework\Stdlib\ArrayManager;

class EcomNextAdapter extends \Ecomero\ErpCore\Model\Erp\ErpAdapter
{
    public const ERP_NAME = 'EcomNext';
    public const MAX_COMMENT_LEN = 60;

    protected $api;
    protected $settings;
    protected $capability;
    protected $orderResponseFactory;
    protected $arrayManager;

    public function __construct(
        EcomNextAPI $api,
        Settings $settings,
        Capability $capability,
        ArrayManager $arrayManager,
        \Magento\Store\Model\StoreManagerInterface $storeManager
    ) {
        parent::__construct($storeManager);

        $this->api = $api;
        $this->settings = $settings;
        $this->capability = $capability;
        $this->arrayManager = $arrayManager;

        $this->capability->setName(self::ERP_NAME);
        $this->capability->setCapability(Capability::PRODUCT_IMPORT, true);
        $this->capability->setCapability(Capability::ORDER_EXPORT, true);
    }

    public function isErpEnabled(): string
    {
        if ($this->settings->isEnabled($this->getWebsite())) {
            return self::ERP_NAME;
        }

        return '';
    }

    public function getCapabilities(): array
    {
        $result[] = $this->capability;

        return $result;
    }
}
