<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\EcomNext\Model\Erp;

use Ecomero\EcomNext\Model\EcomNextAdapter;
use Ecomero\EcomNext\Model\EcomNextAPI;
use Ecomero\ErpCore\Helper\Settings;
use Ecomero\ErpCore\Model\Attribute;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Erp\ErpCatalogInterface;
use Ecomero\ErpCore\Model\ResourceModel\Item\Collection;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Store\Model\StoreManagerInterface;

class Catalog extends EcomNextAdapter implements ErpCatalogInterface
{
    protected $itemListCache = [];

    public function __construct(
        EcomNextAPI $api,
        Settings $settings,
        Capability $capability,
        ArrayManager $arrayManager,
        StoreManagerInterface $storeManager
    ) {
        parent::__construct(
            $api,
            $settings,
            $capability,
            $arrayManager,
            $storeManager,
        );
    }

    public function setItemImportCompleted(): void
    {
    }

    public function getItemPrices(string $category): array
    {
        $result = $this->api->post([
            'command' => 'article-price',
            'filter-category' => $category,
        ]);

        return $this->arrayManager->get('Items', $result);
    }

    public function getItemPriceLists(): array
    {
        return [];
    }

    public function getItemAttributes(string $category): array
    {
        $result = $this->api->post([
            'command' => 'article-attribute',
            'filter-category' => $category,
        ]);

        return $this->arrayManager->get('Items', $result);
    }

    public function getNonInventoryItems(): array
    {
        $rc = [];
        $result = $this->api->post([
            'command' => 'article',
            'filter-type' => 'Non-Inventory',
        ]);

        foreach ($this->arrayManager->get('Items', $result) as $item) {
            $rc[] = [
                'id' => $item['id'],
                'type' => 'non-inv',
                'priceIncludesVAT' => $item['priceIncludesVAT'] ? 'true' : 'false',
                'description' => $item['description'].' (Non-Inv Item)',
                'taxRate' => $item['taxRate'],
            ];
        }

        return $rc;
    }

    public function addPicture(string $itemId, string $imageUrl): int
    {
        return 0;
    }

    public function getItemList(
        string $category,
        bool $force
    ): array {
        $result = $this->api->post([
            'command' => 'article',
            'filter-category' => $category,
        ]);

        $this->itemListCache = $this->arrayManager->get('Items', $result);
        foreach ($this->itemListCache as &$item) {
            $item['commonName'] = $item['description'];
            $item['id'] = $item['sku'];
        }

        return $this->itemListCache;
    }

    public function createCommonName(
        Collection $itemCollection
    ): bool {
        $commonNameAttributes = [];
        if ($this->settings->getCommonNameAttributes($this->getWebsite())) {
            $commonNameAttributes = explode(',', $this->settings->getCommonNameAttributes($this->getWebsite()));
        }

        $configurableAttributes = '';
        if ($this->settings->getConfigurableAttributes($this->getWebsite())) {
            $configurableAttributes = explode(',', $this->settings->getConfigurableAttributes($this->getWebsite()));
        }

        foreach ($itemCollection->getItems() as $item) {
            $item->commonName = '';
            foreach ($commonNameAttributes as $attribute) {
                $attribute = strtolower($attribute);
                if (key_exists($attribute, $item->attributes)) {
                    if ('' === $item->commonName) {
                        $item->commonName = $item->attributes[$attribute]->value;
                    } else {
                        $item->commonName = $item->commonName.'-'.$item->attributes[$attribute]->value;
                    }
                }
            }

            if (null !== $configurableAttributes && '' !== $configurableAttributes) {
                // Clear usedInConfiguration since it may have been set as deault to true by erp core
                foreach ($item->attributes as $key => $value) {
                    $item->attributes[$key]->usedInConfiguration = Attribute::NO;
                }

                // If attribute is a configurable product attribute, then set flag
                foreach ($configurableAttributes as $attribute) {
                    $attribute = strtolower($attribute);
                    if (key_exists($attribute, $item->attributes)) {
                        $item->attributes[$attribute]->usedInConfiguration = Attribute::YES;
                    }
                }
            }
        }

        return true;
    }
}
