<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpB2b\Console\Command;

use Ecomero\ErpB2b\Model\Company\Import;
use Ecomero\ErpCore\Helper\Capability as CapabilityHelper;
use Magento\Framework\App\State;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class ImportCompany extends \Symfony\Component\Console\Command\Command
{
    protected $companyImport;
    protected $state;
    protected $capabilityHelper;

    public function __construct(
        State $state,
        Import $companyImport,
        CapabilityHelper $capabilityHelper
    ) {
        $this->state = $state;
        $this->companyImport = $companyImport;
        $this->capabilityHelper = $capabilityHelper;

        parent::__construct();
    }

    public function isVerbose(OutputInterface $output): bool
    {
        return $output->getVerbosity() >= OutputInterface::VERBOSITY_VERBOSE;
    }

    protected function configure(): void
    {
        if (!$this->capabilityHelper->checkCapability(\Ecomero\ErpCore\Model\Capability::COMPANY_IMPORT)) {
            $this->setHidden(true);
        }

        $this->setName('erp:import:company')
            ->setDescription('Import company from ERP')
        ;

        parent::configure();
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->state->setAreaCode(\Magento\Framework\App\Area::AREA_ADMINHTML);

        $this->companyImport->executeFromShell($output, true);

        return \Magento\Framework\Console\Cli::RETURN_SUCCESS;
    }
}
