<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpB2b\Plugin\Ecomero\ErpCore\Helper;

class CustomerHelper
{
    protected $connection;
    protected $arrayManager;
    protected $customerFactory;

    public function __construct(
        \Magento\Framework\App\ResourceConnection $connection,
        \Magento\Framework\StdLib\ArrayManager $arrayManager,
        \Ecomero\ErpCore\Model\CustomerFactory $customerFactory
    ) {
        $this->connection = $connection;
        $this->arrayManager = $arrayManager;
        $this->customerFactory = $customerFactory;
    }

    public function aroundGetCustomerFromAddress(
        \Ecomero\ErpCore\Helper\CustomerHelper $customerHelper,
        callable $proceed,
        \Magento\Sales\Model\Order\Address $address
    ): \Ecomero\ErpCore\Model\Customer {
        $adapter = $this->connection->getConnection();

        $sql = <<<'SQL'
            SELECT	c.erp_company_no, ce.erp_contact_no  
            FROM 	customer_entity ce
                    JOIN company_advanced_customer_entity cace ON cace.customer_id = ce.entity_id 
                    JOIN company c ON c.entity_id = cace.company_id 
            WHERE	ce.email = ?
SQL;
        $rc = $adapter->fetchRow($sql, [$address->getEmail()]);
        if ($rc) {
            $contactNo = $this->arrayManager->get('erp_contact_no', $rc);
            $companyNo = $this->arrayManager->get('erp_company_no', $rc);
            if ($contactNo && $companyNo) {
                return $this->customerFactory->create(['customerData' => [
                    'number' => $contactNo,
                    'companyId' => $companyNo,
                ]]);
            }
        }

        return $proceed($address);
    }
}
