<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpB2b\Model;

use Ecomero\ErpB2b\Api\Data\CompanyErpInterface;

class CompanyErp extends \Magento\Company\Model\Company implements CompanyErpInterface
{
    public function getErpCompanyNo(): ?string
    {
        return $this->getData(self::ERP_COMPANY_ID);
    }

    public function setErpCompanyNo(string $id)
    {
        return $this->setData(self::ERP_COMPANY_ID, $id);
    }

    public function getErpPriceListId(): ?string
    {
        return $this->getData(self::ERP_PRICE_LIST_ID);
    }

    public function setErpPriceListId(string $id)
    {
        return $this->setData(self::ERP_PRICE_LIST_ID, $id);
    }
}
