<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpB2b\Helper;

class CustomerGroupHelper
{
    public const CUSTOMER_GROUP_GENERAL = 1;

    protected $customerGroupRepository;
    protected $customerGroupFactory;
    protected $searchCriteriaBuilder;
    protected $connection;

    public function __construct(
        \Magento\Customer\Api\GroupRepositoryInterface $customerGroupRepository,
        \Ecomero\ErpB2b\Api\Data\CustomerGroupErpInterfaceFactory $customerGroupFactory,
        \Magento\Framework\Api\SearchCriteriaBuilder $searchCriteriaBuilder,
        \Magento\Framework\App\ResourceConnection $connection
    ) {
        $this->customerGroupRepository = $customerGroupRepository;
        $this->customerGroupFactory = $customerGroupFactory;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->connection = $connection;
    }

    public function createIfNotExist(string $name, string $externalId): \Magento\Customer\Model\Data\Group
    {
        $filter = $this->searchCriteriaBuilder->addFilter('erp_price_list_id', $externalId)->create();

        $collection = $this->customerGroupRepository->getList($filter);
        if (0 === $collection->getTotalCount()) {
            /** @var \Ecomero\ErpB2b\Api\Data\CustomerGroupErpInterface $sc */
            $sc = $this->customerGroupFactory->create();
            $sc->setCode($name);
            $sc->setTaxClassId(\Magento\Customer\Model\ResourceModel\GroupRepository::DEFAULT_TAX_CLASS_ID);

            try {
                $sc = $this->customerGroupRepository->save($sc);
            } catch (\Magento\Framework\Exception\State\InvalidTransitionException $e) {
                $sc->setCode($name." ({$externalId})");
                $sc = $this->customerGroupRepository->save($sc);
            }

            // Update customer group with our external id, this could be impemented as an extension attribute but is is more complicated.
            $adapter = $this->connection->getConnection();
            $adapter->query("UPDATE customer_group SET erp_price_list_id = '{$externalId}' WHERE customer_group_id = {$sc->getId()}");

            return $sc;
        }

        $items = $collection->getItems();

        return reset($items);
    }

    public function deleteImportedTierPrices()
    {
        $adapter = $this->connection->getConnection();
        $sqlStatement = <<<'SQL'
            DELETE	p
            FROM 	catalog_product_entity_tier_price p
                    JOIN customer_group g ON g.customer_group_id  = p.customer_group_id 
            WHERE	g.erp_price_list_id  IS NOT NULL 
SQL;

        $adapter->query($sqlStatement);
    }

    public function updateTierPrices(array $tierPrices, int $customerGroupId)
    {
        $adapter = $this->connection->getConnection();
        foreach ($tierPrices as $website) {
            foreach ($website as $sku) {
                foreach ($sku as $price) {
                    $adapter->insert(
                        'catalog_product_entity_tier_price',
                        $price
                    );
                }
            }
        }
    }

    public function getCustomerGroupFromPriceListId(string $externalId): int
    {
        $filter = $this->searchCriteriaBuilder->addFilter('erp_price_list_id', $externalId)->create();

        $collection = $this->customerGroupRepository->getList($filter);
        if (0 !== $collection->getTotalCount()) {
            $items = $collection->getItems();
            $item = reset($items);

            return (int) $item->getId();
        }

        return self::CUSTOMER_GROUP_GENERAL;
    }
}
