<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpB2b\Helper;

class ProductHelper
{
    protected $connection;

    public function __construct(
        \Magento\Framework\App\ResourceConnection $connection
    ) {
        $this->connection = $connection;
    }

    public function getRowId(string $sku): ?string
    {
        $adapter = $this->connection->getConnection();

        $sqlStatement = <<<SQL
            SELECT	row_id 
            FROM    catalog_product_entity 
            WHERE	sku = '{$sku}'
SQL;

        return $adapter->fetchOne($sqlStatement) ?: null;
    }

    public function getProductIds(string $attributeCode, string $value): array
    {
        $adapter = $this->connection->getConnection();

        $sqlStatement = <<<SQL
            SELECT	e.entity_id, e.sku 
            FROM    catalog_product_entity e
                    JOIN catalog_product_entity_int cpei ON cpei.row_id  = e.row_id
                    JOIN eav_attribute a ON a.attribute_id = cpei.attribute_id AND a.attribute_code = '{$attributeCode}'
                    JOIN eav_attribute_option_value eaov ON eaov.option_id = cpei.value AND eaov.store_id = 0
            WHERE	eaov.value = '{$value}'
SQL;

        return $adapter->fetchAll($sqlStatement);
    }
}
