<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpB2b\Rewrite\Magento\Company\Model\Email;

use Magento\Customer\Api\Data\CustomerInterface;

class Sender extends \Magento\Company\Model\Email\Sender
{
    private static $enableNotifications = true;

    public static function setEnableNotifications(bool $state)
    {
        Sender::$enableNotifications = $state;
    }

    /**
     * Send email to customer with assign message.
     *
     * @param int $companyId
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     *
     * @return $this
     */
    public function sendAssignSuperUserNotificationEmail(CustomerInterface $customer, $companyId)
    {
        if (!Sender::$enableNotifications) {
            return $this;
        }

        return parent::sendAssignSuperUserNotificationEmail($customer, $companyId);
    }

    /**
     * Send email to customer with remove message.
     *
     * @param int $companyId
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     *
     * @return $this
     */
    public function sendRemoveSuperUserNotificationEmail(CustomerInterface $customer, $companyId)
    {
        if (!Sender::$enableNotifications) {
            return $this;
        }

        return parent::sendRemoveSuperUserNotificationEmail($customer, $companyId);
    }

    /**
     * Send email to customer with inactivate message.
     *
     * @param int $companyId
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     *
     * @return $this
     */
    public function sendInactivateSuperUserNotificationEmail(CustomerInterface $customer, $companyId)
    {
        if (!Sender::$enableNotifications) {
            return $this;
        }

        return parent::sendInactivateSuperUserNotificationEmail($customer, $companyId);
    }

    /**
     * Send email to sales representative.
     *
     * @param int $companyId
     * @param int $salesRepresentativeId [optional]
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     *
     * @return $this
     */
    public function sendSalesRepresentativeNotificationEmail($companyId, $salesRepresentativeId = 0)
    {
        if (!Sender::$enableNotifications) {
            return $this;
        }

        return parent::sendSalesRepresentativeNotificationEmail($companyId, $salesRepresentativeId);
    }

    /**
     * Send email to customer after assign company to him.
     *
     * @param int $companyId
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     *
     * @return $this
     */
    public function sendCustomerCompanyAssignNotificationEmail(CustomerInterface $customer, $companyId)
    {
        if (!Sender::$enableNotifications) {
            return $this;
        }

        return parent::sendCustomerCompanyAssignNotificationEmail($customer, $companyId);
    }

    /**
     * Notify admin about new company.
     *
     * @param string $companyName
     * @param string $companyUrl
     *
     * @return $this
     */
    public function sendAdminNotificationEmail(CustomerInterface $customer, $companyName, $companyUrl)
    {
        if (!Sender::$enableNotifications) {
            return $this;
        }

        return parent::sendAdminNotificationEmail($customer, $companyName, $companyUrl);
    }

    /**
     * Notify company admin of company status change.
     *
     * @param int    $companyId
     * @param string $templatePath
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     *
     * @return $this
     */
    public function sendCompanyStatusChangeNotificationEmail(CustomerInterface $customer, $companyId, $templatePath)
    {
        if (!Sender::$enableNotifications) {
            return $this;
        }

        return parent::sendCompanyStatusChangeNotificationEmail($customer, $companyId, $templatePath);
    }

    /**
     * Send email to customer with status update message.
     *
     * @param int $status
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     *
     * @return $this
     */
    public function sendUserStatusChangeNotificationEmail(CustomerInterface $customer, $status)
    {
        if (!Sender::$enableNotifications) {
            return $this;
        }

        return parent::sendUserStatusChangeNotificationEmail($customer, $status);
    }
}
