<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpB2b\Cron;

use Ecomero\ErpB2b\Helper\Data;
use Ecomero\ErpB2b\Model\Company\Import as CompanyImport;
use Ecomero\ErpB2b\Model\Price\Import as PriceImport;
use Ecomero\ErpCore\Helper\ErpLogger;

class RunImport
{
    protected $companyImport;
    protected $priceImport;
    protected $data;
    protected $logger;

    public function __construct(
        CompanyImport $companyImport,
        PriceImport $priceImport,
        Data $data,
        ErpLogger $logger
    ) {
        $this->companyImport = $companyImport;
        $this->priceImport = $priceImport;
        $this->data = $data;
        $this->logger = $logger;
    }

    public function executeEvery1Minute(): int
    {
        $this->executeCronRunners('1MIN');
        return 0;
    }

    public function executeEvery5Minute(): int
    {
        $this->executeCronRunners('5MIN');
        return 0;
    }

    public function executeEvery15Minute(): int
    {
        $this->executeCronRunners('15MIN');
        return 0;
    }

    public function executeEveryHour(): int
    {
        $this->executeCronRunners('HOUR');
        return 0;
    }

    public function executeEvery4thHour(): int
    {
        $this->executeCronRunners('4HOUR');
        return 0;
    }

    public function executeDailyAt4(): int
    {
        $this->executeCronRunners('DAILY');
        return 0;
    }

    private function executeCronRunners(string $frequence) {

        if ($frequence == $this->data->getCronPriceImport()) {
            $this->priceImport->executeFromCron();
        }
        if ($frequence == $this->data->getCronCompanyImport()) {
            $this->companyImport->executeFromCron();
        }
    }
}
