<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpB2b\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Store\Model\ScopeInterface;

class Data extends AbstractHelper
{
    public function getCronCompanyImport($scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): string
    {
        return $this->scopeConfig->getValue('erp_core/cron/cron_company_import', $scope) ?? '';
    }

    public function getCronPriceImport($scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT): string
    {
        return $this->scopeConfig->getValue('erp_core/cron/cron_price_import', $scope) ?? '';
    }

    public function getDefaultLanguageWebsiteId(): int
    {
        return (int) $this->scopeConfig->getValue('erp_core/customer/fallback_website');
    }

    public function getIsActiveOnImport(): bool
    {
        return (bool) $this->scopeConfig->getValue('erp_core/customer/active_on_import');
    }
    public function getDefaultCountryByWebsite(int $websiteId):string
    {
        return $this->scopeConfig->getValue(
            'general/country/default',
            ScopeInterface::SCOPE_WEBSITE,
            $websiteId
        );
    }
}
