<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Block\System\Config\Form\Field;

class ShippingAgent extends \Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray
{
    protected $columns = [];
    protected $agentGroupRenderer;
    protected $freightItemRenderer;
    protected $addAfter = true;
    protected $addButtonLabel;

    protected function _construct()
    {
        parent::_construct();
        $this->addButtonLabel = __('Add');
    }

    protected function getAgentGroupRenderer() : object
    {
        if (!$this->agentGroupRenderer) {
            $this->agentGroupRenderer = $this->getLayout()->createBlock(
                \Ecomero\ErpCore\Block\Adminhtml\Config\Form\Field\ShippingAgentGroup::class,
                '',
                ['data' => ['is_render_to_js_template' => true]]
            );
        }
        return $this->agentGroupRenderer;
    }

    protected function getFreightItemRenderer() : object
    {
        if (!$this->freightItemRenderer) {
            $this->freightItemRenderer = $this->getLayout()->createBlock(
                \Ecomero\ErpCore\Block\Adminhtml\Config\Form\Field\FreightItemGroup::class,
                '',
                ['data' => ['is_render_to_js_template' => true]]
            );
        }
        return $this->freightItemRenderer;
    }

    protected function _prepareToRender() : void
    {
        $this->addColumn('magento_shipping', ['label' => __('Magento Shipping Method')]);
        $this->addColumn(
            'agent_service',
            [
            'label' => __('ERP Shipping Agent/Service'),
            'renderer' => $this->getAgentGroupRenderer(),
                ]
        );
        $this->addColumn(
            'freight_item',
            [
            'label' => __('Freight Item'),
            'renderer' => $this->getFreightItemRenderer(),
                ]
        );
        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add');
    }

    protected function _prepareArrayRow(\Magento\Framework\DataObject $row) : void
    {
        $agentGroup = $row->getAgentService();
        $options = [];
        if ($agentGroup) {
            $options[
                'option_' . $this->getAgentGroupRenderer()->calcOptionHash($agentGroup)
                ] = 'selected="selected"';
        }

        $freightGroup = $row->getFreightItem();
        if ($freightGroup) {
            $options[
                'option_' . $this->getFreightItemRenderer()->calcOptionHash($freightGroup)
                ] = 'selected="selected"';
        }
        $row->setData('option_extra_attrs', $options);
    }

    public function renderCellTemplate($columnName)
    {
        if ($columnName == "active") {
            $this->_columns[$columnName]['class'] = 'input-text required-entry validate-number';
            $this->_columns[$columnName]['style'] = 'width:50px';
        }
        return parent::renderCellTemplate($columnName);
    }
}
