<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Model;

class Item
{
    public $magentoId;
    public $attributeSet;
    public $sku;
    public $categoryIds;
    public $attributes;
    public $description;
    public $commonName = null;
    public $prices;
    public $cost;
    public $inventory;
    public $weight;
    public $associatedProductIds;
    public $categoryFilters;
    public $websiteIds;

    public function __construct()
    {
        $this->attributes = [];
        $this->prices = [];
        $this->categoryIds = [];
        $this->categoryFilters = [];
        $this->websiteIds = [];
    }

    public function getName() : string
    {
        return $this->attributes[ 'name' ]->value;
    }

    public function getCommmonName() : string
    {
        return $this->commonName === null ? $this->description : $this->commonName;
    }

    public function getPrice() : float
    {
        return (float)$this->attributes[ 'price' ]->value;
    }

    public function addCategory(string $categoryId, string $categoryFilter) : void
    {
        $this->categoryIds[] = $categoryId;
        $this->categoryFilters[] = $categoryFilter;
    }

    public function getCategoryIds() : array
    {
        return $this->categoryIds;
    }

    public function getCategoryLabel() : string
    {
        $rc = '';
        foreach ($this->categoryFilters as $filter) {
            $rc = $rc . $filter . ',';
        }
        return rtrim($rc, ',');
    }

    public function addWebsite(int $websiteId) : void
    {
        $this->websiteIds[] = $websiteId;
    }

    public function getWebsiteIds() : array
    {
        return $this->websiteIds;
    }

    public function isSimpleProduct() : bool
    {
        foreach ($this->attributes as $value) {
            if ($value->usedInConfiguration === Attribute::YES) {
                return false;
            }
        }
        return true;
    }
}
