<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Service;

use Ecomero\ErpCore\Helper\ErpLogger;
use Ecomero\ErpCore\Helper\Notification;
use Ecomero\ErpCore\Helper\Settings;
use Ecomero\ErpCore\Helper\TaxItemHelper;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Erp;

use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Sales\Model\ResourceModel\Order\CollectionFactory;

class ExportInvoiceService extends OrderServiceAbstract
{
    protected $productService;
    protected $taxItemHelper;

    public function __construct(
        ErpLogger $logger,
        Notification $notification,
        Erp $erp,
        Settings $settings,
        CustomerService $customerService,
        CollectionFactory $orderCollectionFactory,
        OrderRepositoryInterface $orderRepository,
        ProductService $productService,
        TaxItemHelper $taxItemHelper
    ) {
        parent::__construct(
            $logger,
            $notification,
            $settings,
            $erp,
            $customerService,
            $orderCollectionFactory,
            $orderRepository
        );

        $this->productService = $productService;
        $this->taxItemHelper = $taxItemHelper;
    }

    protected function getServiceDescription() : string
    {
        return 'invoice export';
    }

    protected function getDocumentType() : string
    {
        return 'Invoice';
    }

    protected function getCapability() : string
    {
        return Capability::INVOICE_EXPORT;
    }

    protected function getOrderStatusFilter() : string
    {
        return $this->settings->getOrderStatusSend();
    }

    protected function processOrder(object $order) : void
    {
        if ($this->isDocumentAlreadyInErp($order['increment_id'])) {
            return;
        }

        $orderResponse  = $this->createNewDocument(
            $order,
            $order['order_currency_code']
        );

        $numOrderLines = $this->addDocumentLines($order, $orderResponse, $order['entity_id']);

        $this->addShippingCharges($order, $orderResponse, $order['entity_id'], $numOrderLines);

        // Update order number to "tag" order as completely transferred
        $this->erp->updateDocument(
            $this->getDocumentType(),
            $orderResponse->id,
            $order['increment_id']
        );

        $orderStatusMarkSent = $this->settings->getOrderStatusSent();
        $order->setStatus($orderStatusMarkSent);
        $order->addStatusToHistory(
            $orderStatusMarkSent,
            $this->getDocumentType() . ' sucessfully transferred to Erp with id ' . $orderResponse->number
        );
        $order->setErpOrderNo($orderResponse->number);
        $order->setErpCustomerNo($orderResponse->customerNumber);
        $order->save();
    }
}
