<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Controller\Adminhtml\Synchronization;

use Ecomero\ErpCore\Helper\ErpLogger;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Request\Http;
use Magento\Framework\Controller\Result\RawFactory;
use Magento\Framework\Filesystem\Driver\File;

class Feed extends \Magento\Backend\App\Action
{
    protected $_publicActions = ['feed'];
    protected $resultRawFactory;
    protected $orderLogger;
    protected $productLogger;

    protected $request;
    protected $fileSystem;

    public function __construct(
        Context $context,
        RawFactory $resultRawFactory,
        Http $request,
        ErpLogger $orderLogger,
        ErpLogger $productLogger,
        File $fileSystem
    ) {
        parent::__construct($context);
        $this->resultRawFactory = $resultRawFactory;
        $this->request = $request;
        $this->orderLogger = $orderLogger;
        $this->productLogger = $productLogger;
        $this->fileSystem = $fileSystem;
    }

    private function countLines($hFile) : int
    {
        $linecount = 0;
        while (@stream_get_line($hFile, 1024, "\n")) {
            $linecount ++;
        }
        $this->fileSystem->fileSeek($hFile, 0);
        return $linecount;
    }

    public function execute() : object
    {
        $type = $this->request->getParam('type');
        $lines = $this->request->getParam('lines');
        $result = $this->resultRawFactory->create();

        $fileContent = 'Unknown feed was requested';
        if ($type == 'order_export') {
            $hFile = $this->fileSystem->fileOpen($this->orderLogger->getActiveLogFile(), 'r');
        } elseif ($type == 'product_import') {
            $hFile = $this->fileSystem->fileOpen($this->productLogger->getActiveLogFile(), 'r');
        }

        $fileContent = '';
        $numLines = $this->countLines($hFile);
        $startLine = $numLines - $lines;

        for ($pos = 0; $pos < $startLine; $pos ++) {
            $this->fileSystem->fileReadLine($hFile, 1024, "\n");
        }

        for (; $pos < $numLines; $pos ++) {
            $fileContent = $fileContent . $this->fileSystem->fileReadLine($hFile, 1024, "\n") . "\n";
        }

        $result->setHeader('Content-Type', 'text/plain');
        $result->setContents($fileContent);
        return  $result;
    }
}
