define(['uiElement', 'jquery'], function (UiElement, $) {
    'use strict';

    return UiElement.extend({
        defaults: {
            template: 'Ecomero_ErpCore/logconsole',
            imports: {
                baseUrl: 'logviewer:baseUrl',
                logType: 'logviewer:logType',
                autoScrollMode: 'logviewer.checkbox-autoscroll:checked'
            },
            tracks: {
                logRows: true
            },
            listens: {
                logRows: 'updateView'
            }
        },

        nonce: Date.now(),

        scrollInit: false,

        logRows: [],

        initialize: function () {
            this._super();
            this.interval = setInterval(
                function () {
                    this.onRefresh();
                }.bind(this),
                1000
            );
        },

        onRefresh: function () {
            var url = this.baseUrl + '/feed?type=' + this.logType + '&lines=1000' + '&nonce=' + this.nonce;

            $.get(
                url,
                function (data) {
                    var newLogRows = [];

                    data.split('\n').forEach(function (message, index) {
                        var rowClassName = 'log-row-line-text';

                        if (message !== '') {
                            if (message.includes('<error>')) {
                                message = message.replace('<error>', '');
                                message = message.replace('</error>', '');
                                rowClassName = 'log-row-line-error';
                            } else if (message.includes('<info>')) {
                                message = message.replace('<info>', '');
                                message = message.replace('</info>', '');
                                rowClassName = 'log-row-line-info';
                            }

                            newLogRows.push({
                                row: index + 1,
                                msg: message,
                                cls: rowClassName
                            });
                        }
                    });
                    if (newLogRows.length !== 0) {

                        if( this.logRows.length === 0) {
                            this.logRows = newLogRows;
                        } else if( newLogRows[newLogRows.length - 1].msg !== this.logRows[this.logRows.length - 1].msg ) {
                            this.logRows = newLogRows;
                        }
                    }
                }.bind(this)
            );

            this.nonce += 1;
        },

        updateView: function () {
            if (this.autoScrollMode) {
                setTimeout(
                    function () {
                        $('#lastMessage')[0].scrollIntoView({
                            behavior: this.scrollInit ? 'smooth' : 'auto'
                        });
                        this.scrollInit = true;
                    }.bind(this),
                    100
                );
            }
        }
    });
});
