<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Block\Adminhtml\Config\Form\Field;

use Ecomero\ErpCore\Model\Erp;
use Magento\Framework\View\Element\Context;

class ShippingAgentGroup extends \Magento\Framework\View\Element\Html\Select
{
    protected $erp;

    public function __construct(
        Context $context,
        Erp $erp,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->erp = $erp;
    }

    public function _toHtml() : string
    {
        if (!$this->getOptions()) {
            try {
                $shippingAgents = $this->erp->getShippingAgents();
                foreach ($shippingAgents as $agent) {
                    $this->addOption($agent->code . ' - ' . $agent->serviceCode, $agent->code . ' - ' . $agent->serviceCode);
                }
            } catch (\Zend\Http\Exception\RuntimeException $exception) {
            } catch (\Magento\Framework\Exception\LocalizedException $exception) {
            } catch (\RuntimeException $exception) {
            }
        }
        return parent::_toHtml();
    }

    public function setInputName(string $value) : object
    {
        return $this->setName($value);
    }
}
