<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Console\Command;

use Ecomero\ErpCore\Service\ExportCreditMemoService;
use Magento\Framework\App\State;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class ExportCreditMemos extends \Symfony\Component\Console\Command\Command
{
    protected $state;
    protected $creditMemoService;

    public function __construct(
        State $state,
        ExportCreditMemoService $creditMemoService
    ) {
        parent::__construct();
        $this->state = $state;
        $this->creditMemoService = $creditMemoService;
    }

    const FORCE = 'force';

    protected function configure() : void
    {
        $options = [
            new InputOption(
                self::FORCE,
                null,
                InputOption::VALUE_OPTIONAL,
                'Force'
            )
        ];

        $this->setName("erp:export:credit-memos")
           ->setDescription('Export credit memos to ERP')
           ->setDefinition($options);

        parent::configure();
    }

    protected function execute(InputInterface $input, OutputInterface $output) : void
    {
        $this->state->setAreaCode(\Magento\Framework\App\Area::AREA_ADMINHTML);

        if ($force = $input->getOption(self::FORCE)) {
            $this->creditMemoService->exportCommandLine($output, true);
        } else {
            $this->creditMemoService->exportCommandLine($output, false);
        }
    }

    public function isVerbose(OutputInterface $output) : bool
    {
        return $output->getVerbosity() >= OutputInterface::VERBOSITY_VERBOSE;
    }
}
