<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Helper;

use Magento\Sales\Model\ResourceModel\Order\Tax\Item;

class TaxItemHelper
{
    protected $taxItem;

    public function __construct(
        Item $taxItem
    ) {
        $this->taxItem = $taxItem;
    }

    public function getTaxCodeForOrderLine(string $orderId, ?string $itemId) : string
    {
        $taxItems = $this->taxItem->getTaxItemsByOrderId($orderId);
        foreach ($taxItems as $taxItem) {
            if ($taxItem['item_id'] == $itemId) {
                return $taxItem['code'];
            }
        }
        return "";
    }

    public function getTaxCodeForFirstProduct(string $orderId) : string
    {
        $taxItems = $this->taxItem->getTaxItemsByOrderId($orderId);
        foreach ($taxItems as $taxItem) {
            if ($taxItem['taxable_item_type'] === 'product') {
                return $taxItem['code'];
            }
        }
        return "";
    }

    public function getShippingTaxCodeForOrder(string $orderId) : string
    {
        $taxItems = $this->taxItem->getTaxItemsByOrderId($orderId);
        foreach ($taxItems as $taxItem) {
            if ($taxItem['taxable_item_type'] === 'shipping') {
                return $taxItem['code'];
            }
        }
        return "";
    }
}
