<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Model;

use Ecomero\ErpCore\Helper\ErpLogger;
use Magento\Catalog\Model\Config;
use Magento\Eav\Api\AttributeManagementInterface;

class Attribute
{
    protected $logger;
    protected $config;
    protected $attributeManagement;

    public $type;
    public $name;
    public $value;

    public function __construct(
        ErpLogger $logger,
        Config $config,
        AttributeManagementInterface $attributeManagement
    ) {
        $this->logger = $logger;
        $this->config = $config;
        $this->attributeManagement = $attributeManagement;
    }

    public function setAttribute($product) : void
    {
        $attr = $product->getResource()->getAttribute($this->name)->setStoreId(0);
        if ($attr == null) {
            $this->logger->error("The attribute " . $this->name . " can not be found in Magento!");
        } else {
            $attributeValue = $this->value;
            $existingValue = $product->getData($this->name);

            if ($this->type == "Option") {
                // If we have an attribute of type option, we need to make a lookup
                $attributeValue = $attr->getSource()->getOptionId($this->value);
                if ($attributeValue == null) {
                    $this->logger->error("The attribute option '" . $this->value .
                                         "' cannot be found in Magento for attribute " . $this->name);
                    return;
                }
            }

            if ($this->type == "Decimal") {
                $attributeValue = (float) str_replace(',', '.', $attributeValue);
                $existingValue = (float) str_replace(',', '.', $existingValue);
            }

            if ($attributeValue !== $existingValue) {
                $product->addAttributeUpdate($this->name, $attributeValue, 0);
            }
        }
    }

    public function assignAttributeToAttributeSet($product, string $attributeGroup) :  void
    {
        if (array_key_exists($this->name, $product->getAttributes())) {
            return;
        }

        $attributeSet = $product->getAttributeSetId();

        $group_id = $this->config->getAttributeGroupId($attributeSet, $attributeGroup);
        $this->attributeManagement->assign(
            'catalog_product',
            $attributeSet,
            $group_id,
            $this->name,
            100
        );
    }
}
