<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Model\ResourceModel\Item;

use Ecomero\ErpCore\Model\AttributeFactory;
use Ecomero\ErpCore\Model\ItemFactory;

class Collection
{
    protected $collection;
    protected $itemFactory;
    protected $attributeFactory;

    public function __construct(
        ItemFactory $itemFactory,
        AttributeFactory $attributeFactory
    ) {
        $this->collection = [];
        $this->itemFactory = $itemFactory;
        $this->attributeFactory = $attributeFactory;
    }

    public function count() : int
    {
        return count($this->collection);
    }

    public function getItems() : array
    {
        return $this->collection;
    }

    public function initItems(array $json, int $websiteId, string $categoryId, string $categoryFilter, string $attribSetId) : void
    {
        // Pre process JSON since it may contain duplicates
        foreach ($json as $item) {
            if (array_key_exists($item->sku, $this->collection) == false) {
                $this->collection[$item->sku] = $this->itemFactory->create();
            }

            $this->collection[$item->sku]->sku = $item->sku;
            $this->collection[$item->sku]->category = $item->category;
            $this->collection[$item->sku]->commonName = $item->commonName;
            $this->collection[$item->sku]->description = $item->description;
            $this->collection[$item->sku]->inventory = $item->inventory;
            $this->collection[$item->sku]->cost = $item->cost;
            $this->collection[$item->sku]->weight = $item->weight;

            $this->collection[$item->sku]->attributeSet = $attribSetId;
            $this->collection[$item->sku]->addWebsite($websiteId);
            $this->collection[$item->sku]->addCategory($categoryId, $categoryFilter);

            // Create special attribute for Erp Internal Id
            if (array_key_exists('erp_id', $this->collection[$item->sku]->attributes) == false) {
                $this->collection[$item->sku]->attributes[ 'erp_id' ] = $this->attributeFactory->create();
                $this->collection[$item->sku]->attributes[ 'erp_id' ]->name = 'erp_id';
                $this->collection[$item->sku]->attributes[ 'erp_id' ]->type = 'Text';
                $this->collection[$item->sku]->attributes[ 'erp_id' ]->value = $item->id;
            }

            if (array_key_exists('erp_tax_rate', $this->collection[$item->sku]->attributes) == false) {
                $this->collection[$item->sku]->attributes[ 'erp_tax_rate' ] = $this->attributeFactory->create();
                $this->collection[$item->sku]->attributes[ 'erp_tax_rate' ]->name = 'erp_tax_rate';
                $this->collection[$item->sku]->attributes[ 'erp_tax_rate' ]->type = 'Text';
                $this->collection[$item->sku]->attributes[ 'erp_tax_rate' ]->value = $item->taxRate;
            }

            if (array_key_exists('erp_tax_included', $this->collection[$item->sku]->attributes) == false) {
                $this->collection[$item->sku]->attributes[ 'erp_tax_included' ] = $this->attributeFactory->create();
                $this->collection[$item->sku]->attributes[ 'erp_tax_included' ]->name = 'erp_tax_included';
                $this->collection[$item->sku]->attributes[ 'erp_tax_included' ]->type = 'Text';
                $this->collection[$item->sku]->attributes[ 'erp_tax_included' ]->value = $item->priceIncludesVAT
                    ? "1" : "0";
            }

            if (array_key_exists('name', $this->collection[$item->sku]->attributes) == false) {
                $this->collection[$item->sku]->attributes[ 'name' ] = $this->attributeFactory->create();
                $this->collection[$item->sku]->attributes[ 'name' ]->name = 'name';
                $this->collection[$item->sku]->attributes[ 'name' ]->type = 'Text';
                $this->collection[$item->sku]->attributes[ 'name' ]->value = $item->description;
            }

            if (array_key_exists('price', $this->collection[$item->sku]->attributes) == false) {
                $this->collection[$item->sku]->attributes[ 'price' ] = $this->attributeFactory->create();
                $this->collection[$item->sku]->attributes[ 'price' ]->name = 'price';
                $this->collection[$item->sku]->attributes[ 'price' ]->type = 'Decimal';
                $this->collection[$item->sku]->attributes[ 'price' ]->value = $item->price;
            }
        }
    }

    public function initItemsAttributes(array $json) : void
    {
        // Pre process JSON since it may contain duplicates
        foreach ($json as $item) {
            if (array_key_exists($item->sku, $this->collection) == false) {
                $this->collection[$item->sku] = $this->itemFactory->create();
            }

            if ($item->name != "") {
                $this->collection[$item->sku]->attributes[ strtolower($item->name) ] =
                    $this->attributeFactory->create();
                $this->collection[$item->sku]->attributes[ strtolower($item->name) ]->name = strtolower($item->name);
                $this->collection[$item->sku]->attributes[ strtolower($item->name) ]->type = $item->type;
                $this->collection[$item->sku]->attributes[ strtolower($item->name) ]->value = $item->value;
            }
        }

        // Update name from attribute values
        foreach ($this->collection as $key => $item) {
            $item->attributes[ 'name' ]->value = $this->getNameWithAttributes($item);
        }
    }

    private function getNameWithAttributes(\Ecomero\ErpCore\Model\Item $item) : string
    {
        $itemName = $item->description;

        foreach ($item->attributes as $attrib) {
            if ($attrib->type == 'Option') {
                $itemName = $itemName . '-' . strtoupper($attrib->value);
            }
        }
        return $itemName;
    }

    public function initItemsPrices(array $json) : void
    {
        // Pre process JSON since it may contain duplicates
        foreach ($json as $item) {
            if (array_key_exists($item->sku, $this->collection) == false) {
                $this->collection[$item->sku] = $this->itemFactory->create();
            }

            if ($item->currency != "") {
                $this->collection[$item->sku]->prices[ strtolower($item->currency) ] = $item->priceCurrency;
            }
        }
    }
}
