<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Model;

class ErpAdapter implements \Ecomero\ErpCore\Model\ErpAdapterInterface
{
    private $currentWebsite;
    private $storeManager;

    public function __construct(
        \Magento\Store\Model\StoreManagerInterface $storeManager
    ) {
        $this->storeManager = $storeManager;
    }

    public function setWebsite(int $currentWebsite) : void
    {
        $this->currentWebsite = $currentWebsite;
    }

    public function setWebsiteFromStoredId(int $storeId) : void
    {
        $store = $this->storeManager->getStore($storeId);
        $this->currentWebsite = (int)$store->getWebsiteId();
    }

    public function getWebsite() : int
    {
        return $this->currentWebsite;
    }

    public function isErpEnabled() : string
    {
        return '';
    }

    public function getItemList(String $category, bool $force) : array
    {
        return [];
    }

    public function setItemImportCompleted() : void
    {
    }

    public function getItemPrices(String $category) : array
    {
        return [];
    }

    public function getItemAttributes(String $category) : array
    {
        return [];
    }

    public function getSalesPersons() : array
    {
        return [];
    }

    public function getProfitCenters() : array
    {
        return [];
    }

    public function getTermsOfDeliveries() : array
    {
        return [];
    }

    public function getWayOfDeliveries() : array
    {
        return [];
    }

    public function getCustomerCategories() : array
    {
        return [];
    }

    public function getCustomerDistricts() : array
    {
        return [];
    }

    public function getWayOfDelivery(string $carrier, string $method) : string
    {
        return '';
    }

    public function getDocumentFromExternalId(string $docType, string $magentoOrderId) : object
    {
        return (object)[];
    }

    public function createDocument(
        string $docType,
        string $customerId,
        string $currency,
        array $billingAddress,
        array $shippingAddress,
        ?string $shippingAgent,
        ?string $shippingService,
        ?string $shippingPickupLocationId,
        string $magentoOrderId,
        string $salesPerson,
        ?string $profitCenter,
        ?string $termsOfDelivery,
        ?string $wayOfDelivery,
        ?string $customerCategory,
        ?string $customerDistrict
    ) : object {
        return (object)[];
    }

    public function updateDocument(
        string $docType,
        string $erpId,
        string $magentoOrderId
    ) : object {
        return (object)[];
    }

    public function addDocumentItem(
        string $docType,
        string $orderId,
        string $erpItemId,
        float $price,
        float $qtyOrdered,
        string $vatCode,
        float $discountAmount,
        float $discountPercent,
        ?string $comment
    ) : void {
    }

    public function addChargeItem(
        string $docType,
        string $orderId,
        string $chargingSKU,
        float $price,
        float $qtyOrdered,
        string $vatCode,
        string $invoiceNo,
        int $numOrderLines
    ) : void {
    }

    public function getCustomerFromEmail(string $email) : object
    {
        return (object)[];
    }

    public function createCustomer(
        ?string $company,
        ?string $firstName,
        ?string $lastName,
        ?string $street,
        ?string $city,
        ?string $postCode,
        ?string $email,
        ?string $phone,
        ?string $country,
        ?string $region
    ) : object {
        return (object)[];
    }

    public function getShippingAgents() : array
    {
        return [];
    }

    public function getAggregatedFreightOptions() : array
    {
        return [];
    }

    public function getNonInventoryItems() : array
    {
        return [];
    }

    public function getShippment(string $orderNo) : array
    {
        return [];
    }

    public function getInvoiceFromOrder(string $orderNo) : object
    {
        return (object)[];
    }

    public function getInvoiceOrderLines(string $invoiceNo) : array
    {
        return [];
    }

    public function createCreditMemo(
        string $creditMemoDate,
        string $orderNumber,
        string $invoiceNumber,
        string $customerNumber
    ) : object {
        return (object)[];
    }

    public function addCreditMemoItem(
        string $creditMemoId,
        string $bcItemId,
        float $price,
        float $qtyOrdered,
        string $vatCode,
        float $discountAmount,
        float $discountPercent
    ) : void {
    }

    public function addCreditMemoCharge(
        string $creditMemoId,
        string $chargingSKU,
        float $price,
        float $qtyOrdered,
        string $vatCode,
        string $invoiceNo,
        int $numOrderLines
    ) : void {
    }

    public function addPicture(string $itemId, string $imageUrl) : int
    {
        return 0;
    }

    public function getCapabilities() : array
    {
        return [];
    }

    public function createCommonName(
        \Ecomero\ErpCore\Model\ResourceModel\Item\Collection $itemCollection
    ) : bool {
        return false;
    }

    public function getReturns() : array
    {
        return [];
    }
}
