<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Model;

interface ErpAdapterInterface
{
    public function setWebsite(int $currentWebsite) : void;
    public function setWebsiteFromStoredId(int $storeId) : void;
    public function getWebsite() : int;
    public function isErpEnabled() : string;
    public function getItemList(String $category, bool $force) : array;
    public function setItemImportCompleted() : void;
    public function getItemPrices(String $category) : array;
    public function getItemAttributes(String $category) : array;
    public function getSalesPersons() : array;
    public function getProfitCenters() : array;
    public function getTermsOfDeliveries() : array;
    public function getWayOfDeliveries() : array;
    public function getCustomerCategories() : array;
    public function getCustomerDistricts() : array;
    public function getWayOfDelivery(string $carrier, string $method) : string;
    public function getDocumentFromExternalId(string $docType, string $magentoOrderId) : object;
    public function createDocument(
        string $docType,
        string $customerId,
        string $currency,
        array $billingAddress,
        array $shippingAddress,
        ?string $shippingAgent,
        ?string $shippingService,
        ?string $shippingPickupLocationId,
        string $magentoOrderId,
        string $salesPerson,
        ?string $profitCenter,
        ?string $termsOfDelivery,
        ?string $wayOfDelivery,
        ?string $customerCategory,
        ?string $customerDistrict
    ) : object;

    public function updateDocument(
        string $docType,
        string $erpId,
        string $magentoOrderId
    ) : object;

    public function addDocumentItem(
        string $docType,
        string $orderId,
        string $erpItemId,
        float $price,
        float $qtyOrdered,
        string $vatCode,
        float $discountAmount,
        float $discountPercent,
        ?string $comment
    ) : void;

    public function addChargeItem(
        string $docType,
        string $orderId,
        string $chargingSKU,
        float $price,
        float $qtyOrdered,
        string $vatCode,
        string $invoiceNo,
        int $numOrderLines
    ) : void;

    public function getCustomerFromEmail(string $email) : object;

    public function createCustomer(
        ?string $company,
        ?string $firstName,
        ?string $lastName,
        ?string $street,
        ?string $city,
        ?string $postCode,
        ?string $email,
        ?string $phone,
        ?string $country,
        ?string $region
    ) : object;

    public function getShippingAgents() : array;
    public function getAggregatedFreightOptions() : array;
    public function getNonInventoryItems() : array;
    public function getShippment(string $orderNo) : array;
    public function getInvoiceFromOrder(string $orderNo) : object;
    public function getInvoiceOrderLines(string $invoiceNo) : array;
    public function createCreditMemo(
        string $creditMemoDate,
        string $orderNumber,
        string $invoiceNumber,
        string $customerNumber
    ) : object;

    public function addCreditMemoItem(
        string $creditMemoId,
        string $bcItemId,
        float $price,
        float $qtyOrdered,
        string $vatCode,
        float $discountAmount,
        float $discountPercent
    ) : void;

    public function addCreditMemoCharge(
        string $creditMemoId,
        string $chargingSKU,
        float $price,
        float $qtyOrdered,
        string $vatCode,
        string $invoiceNo,
        int $numOrderLines
    ) : void;

    public function addPicture(string $itemId, string $imageUrl) : int;
    public function getCapabilities() : array;
    public function createCommonName(
        \Ecomero\ErpCore\Model\ResourceModel\Item\Collection $itemCollection
    ) : bool;

    public function getReturns() : array;
}
