<?php

namespace Ecomero\ErpCore\Block\Adminhtml\Config\Form\Field;

use Magento\Config\Block\System\Config\Form\Field;

class ModuleVersion extends Field
{
    protected $componentRegistrar;
    protected $readFactory;

    public function __construct(
        \Magento\Framework\Component\ComponentRegistrarInterface $componentRegistrar,
        \Magento\Framework\Filesystem\Directory\ReadFactory $readFactory
    ) {
        $this->componentRegistrar = $componentRegistrar;
        $this->readFactory = $readFactory;
    }

    public function getModuleVersion($moduleName)
    {
        $path = $this->componentRegistrar->getPath(
            \Magento\Framework\Component\ComponentRegistrar::MODULE,
            $moduleName
        );
        $directoryRead = $this->readFactory->create($path);
        $composerJsonData = $directoryRead->readFile('composer.json');
        $data = json_decode($composerJsonData);

        return !empty($data->version) ? $data->version : __('Read error!');
    }

    public function render(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        $html = '<td class="label"><label for="' .
        $element->getHtmlId() . '"><span>' .
        $element->getLabel() .
        '</span></label></td>';

        $html .= '<td class="value">';

        $moduleName = $element->getComment()->getText();
        $html .= $this->getModuleVersion($moduleName);
        $html .= '</td>';

        return $this->_decorateRowHtml($element, $html);
    }
}
