<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Cron;

use Ecomero\ErpCore\Helper\ErpLogger;
use Ecomero\ErpCore\Helper\Settings;
use Ecomero\ErpCore\Service\ExportCreditMemoService;
use Ecomero\ErpCore\Service\ExportInvoiceService;
use Ecomero\ErpCore\Service\ExportOrderService;
use Ecomero\ErpCore\Service\ImportInvoiceService;
use Ecomero\ErpCore\Service\ImportShipmentService;
use Ecomero\ErpCore\Service\ProductService;
use Ecomero\ErpCore\Service\ReturnService;

class RunImport
{
    protected $importProductService;
    protected $importShipmentService;
    protected $exportInvoiceService;
    protected $importInvoiceService;
    protected $exportOrderService;
    protected $exportCreditMemoService;
    protected $returnService;
    protected $settings;
    protected $logger;

    public function __construct(
        ProductService $importProductService,
        ImportShipmentService $importShipmentService,
        ExportInvoiceService $exportInvoiceService,
        ImportInvoiceService $importInvoiceService,
        ExportOrderService $exportOrderService,
        ExportCreditMemoService $exportCreditMemoService,
        ReturnService $returnService,
        Settings $settings,
        ErpLogger $logger
    ) {
        $this->importProductService = $importProductService;
        $this->importShipmentService = $importShipmentService;
        $this->exportInvoiceService = $exportInvoiceService;
        $this->importInvoiceService = $importInvoiceService;
        $this->exportOrderService = $exportOrderService;
        $this->exportCreditMemoService = $exportCreditMemoService;
        $this->returnService = $returnService;
        $this->settings = $settings;
        $this->logger = $logger;
    }

    public function executeEvery1Minute() : int
    {
        if ($this->settings->getCronProductImport() == '1MIN') {
            $this->importProductService->importCron();
        }
        if ($this->settings->getCronOrderExport() == '1MIN') {
            $this->exportOrderService->executeFromCron();
        }
        if ($this->settings->getCronInvoiceExport() == '1MIN') {
            $this->exportInvoiceService->executeFromCron();
        }
        if ($this->settings->getCronCreditMemoExport() == '1MIN') {
            $this->exportCreditMemoService->exportCron();
        }
        if ($this->settings->getCronShipmentImport() == '1MIN') {
            $this->importShipmentService->executeFromCron();
        }
        if ($this->settings->getCronInvoiceImport() == '1MIN') {
            $this->importInvoiceService->executeFromCron();
        }
        if ($this->settings->getCronReturnImport() == '1MIN') {
            $this->returnService->executeFromCron();
        }
        return 0;
    }

    public function executeEvery5Minute() : int
    {
        if ($this->settings->getCronProductImport() == '5MIN') {
            $this->importProductService->importCron();
        }
        if ($this->settings->getCronOrderExport() == '5MIN') {
            $this->exportOrderService->executeFromCron();
        }
        if ($this->settings->getCronInvoiceExport() == '5MIN') {
            $this->exportInvoiceService->executeFromCron();
        }
        if ($this->settings->getCronCreditMemoExport() == '5MIN') {
            $this->exportCreditMemoService->exportCron();
        }
        if ($this->settings->getCronShipmentImport() == '5MIN') {
            $this->importShipmentService->executeFromCron();
        }
        if ($this->settings->getCronInvoiceImport() == '5MIN') {
            $this->importInvoiceService->executeFromCron();
        }
        if ($this->settings->getCronReturnImport() == '5MIN') {
            $this->returnService->executeFromCron();
        }
        return 0;
    }

    public function executeEvery15Minute() : int
    {
        if ($this->settings->getCronProductImport() == '15MIN') {
            $this->importProductService->importCron();
        }
        if ($this->settings->getCronOrderExport() == '15MIN') {
            $this->exportOrderService->executeFromCron();
        }
        if ($this->settings->getCronInvoiceExport() == '15MIN') {
            $this->exportInvoiceService->executeFromCron();
        }
        if ($this->settings->getCronCreditMemoExport() == '15MIN') {
            $this->exportCreditMemoService->exportCron();
        }
        if ($this->settings->getCronShipmentImport() == '15MIN') {
            $this->importShipmentService->executeFromCron();
        }
        if ($this->settings->getCronInvoiceImport() == '15MIN') {
            $this->importInvoiceService->executeFromCron();
        }
        if ($this->settings->getCronReturnImport() == '15MIN') {
            $this->returnService->executeFromCron();
        }
        return 0;
    }

    public function executeEveryHour() : int
    {
        if ($this->settings->getCronProductImport() == 'HOUR') {
            $this->importProductService->importCron();
        }
        if ($this->settings->getCronOrderExport() == 'HOUR') {
            $this->exportOrderService->executeFromCron();
        }
        if ($this->settings->getCronInvoiceExport() == 'HOUR') {
            $this->exportInvoiceService->executeFromCron();
        }
        if ($this->settings->getCronCreditMemoExport() == 'HOUR') {
            $this->exportCreditMemoService->exportCron();
        }
        if ($this->settings->getCronShipmentImport() == 'HOUR') {
            $this->importShipmentService->executeFromCron();
        }
        if ($this->settings->getCronInvoiceImport() == 'HOUR') {
            $this->importInvoiceService->executeFromCron();
        }
        if ($this->settings->getCronReturnImport() == 'HOUR') {
            $this->returnService->executeFromCron();
        }
        return 0;
    }

    public function executeEvery4thHour() : int
    {
        if ($this->settings->getCronProductImport() == '4HOUR') {
            $this->importProductService->importCron();
        }
        if ($this->settings->getCronOrderExport() == '4HOUR') {
            $this->exportOrderService->executeFromCron();
        }
        if ($this->settings->getCronInvoiceExport() == '4HOUR') {
            $this->exportInvoiceService->executeFromCron();
        }
        if ($this->settings->getCronCreditMemoExport() == '4HOUR') {
            $this->exportCreditMemoService->exportCron();
        }
        if ($this->settings->getCronShipmentImport() == '4HOUR') {
            $this->importShipmentService->executeFromCron();
        }
        if ($this->settings->getCronInvoiceImport() == '4HOUR') {
            $this->importInvoiceService->executeFromCron();
        }
        if ($this->settings->getCronReturnImport() == '4HOUR') {
            $this->returnService->executeFromCron();
        }
        return 0;
    }

    public function executeDailyAt4() : int
    {
        if ($this->settings->getCronProductImport() == 'DAILY') {
            $this->importProductService->importCron();
        }
        if ($this->settings->getCronOrderExport() == 'DAILY') {
            $this->exportOrderService->executeFromCron();
        }
        if ($this->settings->getCronInvoiceExport() == 'DAILY') {
            $this->exportInvoiceService->executeFromCron();
        }
        if ($this->settings->getCronCreditMemoExport() == 'DAILY') {
            $this->exportCreditMemoService->exportCron();
        }
        if ($this->settings->getCronShipmentImport() == 'DAILY') {
            $this->importShipmentService->executeFromCron();
        }
        if ($this->settings->getCronInvoiceImport() == 'DAILY') {
            $this->importInvoiceService->executeFromCron();
        }
        if ($this->settings->getCronReturnImport() == 'DAILY') {
            $this->returnService->executeFromCron();
        }

        // Internal daily maintenance tasks
        $this->logger->deleteOldLogfiles();

        return 0;
    }
}
