<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Block\System\Config\Form\Field;

class ProductCategoryMapper extends \Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray
{
    protected $columns = [];
    protected $productCategoryRenderer;
    protected $attributeSetRenderer;
    protected $addAfter = true;
    protected $addButtonLabel;

    protected function _construct()
    {
        parent::_construct();
        $this->addButtonLabel = __('Add');
    }

    protected function getProductCategoryRenderer() : object
    {
        if (!$this->productCategoryRenderer) {
            $this->productCategoryRenderer = $this->getLayout()->createBlock(
                \Ecomero\ErpCore\Block\Adminhtml\Config\Form\Field\ProductCategory::class,
                '',
                ['data' => ['is_render_to_js_template' => true]]
            );
        }
        return $this->productCategoryRenderer;
    }

    protected function getAttributeSetRenderer() : object
    {
        if (!$this->attributeSetRenderer) {
            $this->attributeSetRenderer = $this->getLayout()->createBlock(
                \Ecomero\ErpCore\Block\Adminhtml\Config\Form\Field\AttributeSet::class,
                '',
                ['data' => ['is_render_to_js_template' => true]]
            );
        }
        return $this->attributeSetRenderer;
    }

    protected function _prepareToRender() : void
    {
        $this->addColumn('category_filter', ['label' => __('ERP Category')]);
        $this->addColumn(
            'product_category',
            [
            'label' => __('Product Category'),
            'renderer' => $this->getProductCategoryRenderer(),
                ]
        );
        $this->addColumn(
            'attribute_set',
            [
            'label' => __('Attribute Set'),
            'renderer' => $this->getAttributeSetRenderer(),
                ]
        );
        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add');
    }

    protected function _prepareArrayRow(\Magento\Framework\DataObject $row) : void
    {
        $prodCategory = $row->getProductCategory();
        $options = [];
        if ($prodCategory) {
            $options[
                'option_' . $this->getProductCategoryRenderer()->calcOptionHash($prodCategory)
                ] = 'selected="selected"';
        }

        $attrSet = $row->getAttributeSet();
        if ($attrSet) {
            $options[
                'option_' . $this->getAttributeSetRenderer()->calcOptionHash($attrSet)
                ] = 'selected="selected"';
        }

        $row->setData('option_extra_attrs', $options);
    }

    public function renderCellTemplate($columnName)
    {
        if ($columnName == "active") {
            $this->_columns[$columnName]['class'] = 'input-text required-entry validate-number';
            $this->_columns[$columnName]['style'] = 'width:50px';
        }
        return parent::renderCellTemplate($columnName);
    }
}
