<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Plugin;

use Magento\Config\Model\ResourceModel\Config\Data\CollectionFactory;

class ConfigFormPlugin
{
    protected $configCollectionFactory;

    public function __construct(
        CollectionFactory $configCollectionFactory
    ) {
        $this->configCollectionFactory = $configCollectionFactory;
    }

    public function afterGetConfigValue(\Magento\Config\Block\System\Config\Form $type, $result, string $path)
    {
        if ($path === 'erp_core/cron/locked') {
            $result = '1';
            $configCollection = $this->configCollectionFactory->create()
                                                                ->addFieldToSelect('path')
                                                                ->addFieldToSelect('value');
            foreach ($configCollection->getData() as $setting) {
                if ($setting['path'] === 'erp_core/cron/locked') {
                    $result =   $setting['value'];
                    break;
                }
            }
        }

        return  $result;
    }
}
