<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Console\Command;

use Ecomero\ErpCore\Service\ExportOrderService;
use Magento\Framework\App\State;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class ExportOrders extends \Symfony\Component\Console\Command\Command
{
    protected $state;
    protected $orderService;

    public function __construct(
        State $state,
        ExportOrderService $orderService
    ) {
        parent::__construct();
        $this->state = $state;
        $this->orderService = $orderService;
    }

    const FORCE = 'force';

    protected function configure() : void
    {
        $options = [
            new InputOption(
                self::FORCE,
                null,
                InputOption::VALUE_OPTIONAL,
                'Force'
            )
        ];

        $this->setName("erp:export:orders")
           ->setDescription('Export orders to ERP')
           ->setDefinition($options);

        parent::configure();
    }

    protected function execute(InputInterface $input, OutputInterface $output) : int
    {
        $this->state->setAreaCode(\Magento\Framework\App\Area::AREA_ADMINHTML);

        if ($force = $input->getOption(self::FORCE)) {
            $this->orderService->executeFromShell($output, true);
        } else {
            $this->orderService->executeFromShell($output, false);
        }
        return \Magento\Framework\Console\Cli::RETURN_SUCCESS;
    }

    public function isVerbose(OutputInterface $output) : bool
    {
        return $output->getVerbosity() >= OutputInterface::VERBOSITY_VERBOSE;
    }
}
