<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Controller\Adminhtml\Synchronization;

use Ecomero\ErpCore\Service\ExportCreditMemoService;
use Ecomero\ErpCore\Service\ExportInvoiceService;
use Ecomero\ErpCore\Service\ExportOrderService;
use Ecomero\ErpCore\Service\ImageService;
use Ecomero\ErpCore\Service\ImportInvoiceService;
use Ecomero\ErpCore\Service\ImportShipmentService;
use Ecomero\ErpCore\Service\ProductService;
use Ecomero\ErpCore\Service\ReturnService;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\Result\JsonFactory;

class CommandControl extends \Magento\Backend\App\Action implements CsrfAwareActionInterface
{
    protected $resultJsonFactory;
    protected $importProductService;
    protected $importShipmentService;
    protected $importInvoiceService;
    protected $exportInvoiceService;
    protected $exportOrderService;
    protected $exportCreditMemoService;
    protected $exportImageService;
    protected $importReturnService;

    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory,
        ProductService $importProductService,
        ImportShipmentService $importShipmentService,
        ImportInvoiceService $importInvoiceService,
        ExportInvoiceService $exportInvoiceService,
        ExportOrderService $exportOrderService,
        ExportCreditMemoService $exportCreditMemoService,
        ImageService $exportImageService,
        ReturnService $importReturnService
    ) {
        parent::__construct($context);

        $this->resultJsonFactory = $resultJsonFactory;
        $this->importProductService = $importProductService;
        $this->importShipmentService = $importShipmentService;
        $this->importInvoiceService = $importInvoiceService;
        $this->exportInvoiceService = $exportInvoiceService;
        $this->exportOrderService = $exportOrderService;
        $this->exportCreditMemoService = $exportCreditMemoService;
        $this->exportImageService = $exportImageService;
        $this->importReturnService = $importReturnService;
    }

    public function createCsrfValidationException(RequestInterface $request): ? InvalidRequestException
    {
        return null;
    }

    public function validateForCsrf(RequestInterface $request): ?bool
    {
        return true;
    }

    public function execute() : object
    {
        $command = $this->_request->getParam('command');

        if ($command == 'import_products') {
            $this->importProductService->importWeb();
        }
        if ($command == 'import_shipments') {
            $this->importShipmentService->executeFromWeb()();
        }
        if ($command == 'import_invoices') {
            $this->importInvoiceService->executeFromWeb();
        }
        if ($command == 'export_invoices') {
            $this->exportInvoiceService->executeFromWeb();
        }
        if ($command == 'export_orders') {
            $this->exportOrderService->executeFromWeb();
        }
        if ($command == 'export_credit_memos') {
            $this->exportCreditMemoService->exportWeb();
        }
        if ($command == 'export_images') {
            $this->exportImageService->exportWeb();
        }
        if ($command == 'import_returns') {
            $this->importReturnService->executeFromWeb();
        }

        $result = $this->resultJsonFactory->create();
        $result->setData([ 'status' => 'ok']);

        $result->setHeader('Cache-Control', 'no-cache', true);
        $result->setHeader('Access-Control-Allow-Headers', '*', true);
        $result->setHeader('Access-Control-Allow-Origin', '*', true);
        return  $result;
    }
}
