<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\ErpCore\Model;

class Capability
{
    public const PRODUCT_IMPORT = 'PRODUCT_IMPORT';
    public const PRODUCT_PICTURE_EXPORT = 'PRODUCT_PICTURE_EXPORT';
    public const ORDER_EXPORT = 'ORDER_EXPORT';
    public const ORDER_IMPORT = 'ORDER_IMPORT';
    public const CREDIT_MEMO_EXPORT ='CREDIT_MEMO_EXPORT';
    public const INVOICE_EXPORT = 'INVOICE_EXPORT';
    public const INVOICE_IMPORT = 'INVOICE_IMPORT';
    public const SHIPMENT_IMPORT = 'SHIPMENT_IMPORT';
    public const RETURN_IMPORT = 'RETURN_IMPORT';

    protected $capabilities = [];
    protected $name;

    public function setName(string $name) : void
    {
        $this->name = $name;
    }

    public function getName() : string
    {
        return $this->name;
    }

    public function setCapability(string $capability, bool $isSupported)
    {
        $this->capabilities[$capability] = $isSupported;
    }

    public function isCapabilitySupported(string $capability) : bool
    {
        if (array_key_exists($capability, $this->capabilities) === true) {
            return $this->capabilities[$capability];
        }
        return false;
    }
}
