<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Block\Adminhtml\Config\Form\Field;

use Ecomero\ErpCore\Model\Erp\ErpShippingInterface;
use Magento\Framework\View\Element\Context;

class FreightItemGroup extends \Magento\Framework\View\Element\Html\Select
{
    protected $erp;

    public function __construct(
        Context $context,
        ErpShippingInterface $erp,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->erp = $erp;
    }

    public function _toHtml(): string
    {
        if (!$this->getOptions()) {
            try {
                $freightItems = $this->erp->getAggregatedFreightOptions();
                foreach ($freightItems as $item) {
                    $this->addOption($item['id'].'#'.$item['type'].'#'.$item['priceIncludesVAT'].'#'.$item['taxRate'], $item['description']);
                }
            } catch (\Laminas\Http\Exception\RuntimeException $exception) {
            } catch (\Magento\Framework\Exception\LocalizedException $exception) {
            } catch (\RuntimeException $exception) {
            }
        }

        return parent::_toHtml();
    }

    public function setInputName(string $value): object
    {
        return $this->setName($value);
    }
}
