<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Cron;

use Ecomero\ErpCore\Helper\ErpLogger;
use Ecomero\ErpCore\Helper\Settings;
use Ecomero\ErpCore\Model\Catalog\CatalogImport;
use Ecomero\ErpCore\Model\Invoice\InvoiceExport;
use Ecomero\ErpCore\Model\Invoice\InvoiceImport;
use Ecomero\ErpCore\Model\Order\CreditMemoExport;
use Ecomero\ErpCore\Model\Order\OrderExport;
use Ecomero\ErpCore\Model\Rma\RmaImport;
use Ecomero\ErpCore\Model\Shipping\ShippingImport;

class RunImport
{
    protected $catalogImport;
    protected $shippingImport;
    protected $invoiceExport;
    protected $invoiceImport;
    protected $orderExport;
    protected $creditMemoExport;
    protected $rmaImport;
    protected $settings;
    protected $logger;

    public function __construct(
        CatalogImport $catalogImport,
        ShippingImport $shippingImport,
        InvoiceExport $invoiceExport,
        InvoiceImport $invoiceImport,
        OrderExport $orderExport,
        CreditMemoExport $creditMemoExport,
        RmaImport $rmaImport,
        Settings $settings,
        ErpLogger $logger
    ) {
        $this->catalogImport = $catalogImport;
        $this->shippingImport = $shippingImport;
        $this->invoiceExport = $invoiceExport;
        $this->invoiceImport = $invoiceImport;
        $this->orderExport = $orderExport;
        $this->creditMemoExport = $creditMemoExport;
        $this->rmaImport = $rmaImport;
        $this->settings = $settings;
        $this->logger = $logger;
    }

    public function executeEvery1Minute(): int
    {
        if ('1MIN' == $this->settings->getCronProductImport()) {
            $this->catalogImport->executeFromCron();
        }
        if ('1MIN' == $this->settings->getCronOrderExport()) {
            $this->orderExport->executeFromCron();
        }
        if ('1MIN' == $this->settings->getCronInvoiceExport()) {
            $this->invoiceExport->executeFromCron();
        }
        if ('1MIN' == $this->settings->getCronCreditMemoExport()) {
            $this->creditMemoExport->executeFromCron();
        }
        if ('1MIN' == $this->settings->getCronShipmentImport()) {
            $this->shippingImport->executeFromCron();
        }
        if ('1MIN' == $this->settings->getCronInvoiceImport()) {
            $this->invoiceImport->executeFromCron();
        }
        if ('1MIN' == $this->settings->getCronReturnImport()) {
            $this->rmaImport->executeFromCron();
        }

        return 0;
    }

    public function executeEvery5Minute(): int
    {
        if ('5MIN' == $this->settings->getCronProductImport()) {
            $this->catalogImport->executeFromCron();
        }
        if ('5MIN' == $this->settings->getCronOrderExport()) {
            $this->orderExport->executeFromCron();
        }
        if ('5MIN' == $this->settings->getCronInvoiceExport()) {
            $this->invoiceExport->executeFromCron();
        }
        if ('5MIN' == $this->settings->getCronCreditMemoExport()) {
            $this->creditMemoExport->executeFromCron();
        }
        if ('5MIN' == $this->settings->getCronShipmentImport()) {
            $this->shippingImport->executeFromCron();
        }
        if ('5MIN' == $this->settings->getCronInvoiceImport()) {
            $this->invoiceImport->executeFromCron();
        }
        if ('5MIN' == $this->settings->getCronReturnImport()) {
            $this->rmaImport->executeFromCron();
        }

        return 0;
    }

    public function executeEvery15Minute(): int
    {
        if ('15MIN' == $this->settings->getCronProductImport()) {
            $this->catalogImport->executeFromCron();
        }
        if ('15MIN' == $this->settings->getCronOrderExport()) {
            $this->orderExport->executeFromCron();
        }
        if ('15MIN' == $this->settings->getCronInvoiceExport()) {
            $this->invoiceExport->executeFromCron();
        }
        if ('15MIN' == $this->settings->getCronCreditMemoExport()) {
            $this->creditMemoExport->executeFromCron();
        }
        if ('15MIN' == $this->settings->getCronShipmentImport()) {
            $this->shippingImport->executeFromCron();
        }
        if ('15MIN' == $this->settings->getCronInvoiceImport()) {
            $this->invoiceImport->executeFromCron();
        }
        if ('15MIN' == $this->settings->getCronReturnImport()) {
            $this->rmaImport->executeFromCron();
        }

        return 0;
    }

    public function executeEveryHour(): int
    {
        if ('HOUR' == $this->settings->getCronProductImport()) {
            $this->catalogImport->executeFromCron();
        }
        if ('HOUR' == $this->settings->getCronOrderExport()) {
            $this->orderExport->executeFromCron();
        }
        if ('HOUR' == $this->settings->getCronInvoiceExport()) {
            $this->invoiceExport->executeFromCron();
        }
        if ('HOUR' == $this->settings->getCronCreditMemoExport()) {
            $this->creditMemoExport->executeFromCron();
        }
        if ('HOUR' == $this->settings->getCronShipmentImport()) {
            $this->shippingImport->executeFromCron();
        }
        if ('HOUR' == $this->settings->getCronInvoiceImport()) {
            $this->invoiceImport->executeFromCron();
        }
        if ('HOUR' == $this->settings->getCronReturnImport()) {
            $this->rmaImport->executeFromCron();
        }

        return 0;
    }

    public function executeEvery4thHour(): int
    {
        if ('4HOUR' == $this->settings->getCronProductImport()) {
            $this->catalogImport->executeFromCron();
        }
        if ('4HOUR' == $this->settings->getCronOrderExport()) {
            $this->orderExport->executeFromCron();
        }
        if ('4HOUR' == $this->settings->getCronInvoiceExport()) {
            $this->invoiceExport->executeFromCron();
        }
        if ('4HOUR' == $this->settings->getCronCreditMemoExport()) {
            $this->creditMemoExport->executeFromCron();
        }
        if ('4HOUR' == $this->settings->getCronShipmentImport()) {
            $this->shippingImport->executeFromCron();
        }
        if ('4HOUR' == $this->settings->getCronInvoiceImport()) {
            $this->invoiceImport->executeFromCron();
        }
        if ('4HOUR' == $this->settings->getCronReturnImport()) {
            $this->rmaImport->executeFromCron();
        }

        return 0;
    }

    public function executeDailyAt4(): int
    {
        if ('DAILY' == $this->settings->getCronProductImport()) {
            $this->catalogImport->executeFromCron();
        }
        if ('DAILY' == $this->settings->getCronOrderExport()) {
            $this->orderExport->executeFromCron();
        }
        if ('DAILY' == $this->settings->getCronInvoiceExport()) {
            $this->invoiceExport->executeFromCron();
        }
        if ('DAILY' == $this->settings->getCronCreditMemoExport()) {
            $this->creditMemoExport->executeFromCron();
        }
        if ('DAILY' == $this->settings->getCronShipmentImport()) {
            $this->shippingImport->executeFromCron();
        }
        if ('DAILY' == $this->settings->getCronInvoiceImport()) {
            $this->invoiceImport->executeFromCron();
        }
        if ('DAILY' == $this->settings->getCronReturnImport()) {
            $this->rmaImport->executeFromCron();
        }

        // Internal daily maintenance tasks
        $this->logger->deleteOldLogfiles();

        return 0;
    }
}
