<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Model;

class Customer extends \Magento\Framework\DataObject
{
    public function __construct(
        array $customerData
    ) {
        parent::__construct($customerData);
    }

    public function getPostalCode(): ?string
    {
        return $this->getData('postalCode');
    }

    public function getCustomerNumber(): ?string
    {
        return $this->getNumber();
    }

    public function getCompanyNumber(): ?string
    {
        return $this->getData('companyId');
    }
}
