<?php

namespace Ecomero\ErpCore\Block\Adminhtml\Config\Form\Field;

use Magento\Config\Block\System\Config\Form\Field;
use Ecomero\ErpCore\Model\Erp\ErpCatalogInterface;

class ErpModuleVersion extends Field
{
    protected $erp;

    public function __construct(
        ErpCatalogInterface $erp
    ) {
        $this->erp = $erp;
    }

    public function render(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        $html = '<td class="label"><label for="' .
        $element->getHtmlId() . '"><span>' .
        $element->getLabel() .
        '</span></label></td>';

        $html .= '<td class="value">';

        $html .= $this->erp->getErpExtVersion();
        $html .= '</td>';

        return $this->_decorateRowHtml($element, $html);
    }
}
