<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\ErpCore\Model\Erp;

interface ErpOrderInterface extends ErpAdapterInterface
{
    public function getSalesPersons(): array;

    public function getProfitCenters(): array;

    public function getDocumentFromExternalId(string $docType, string $magentoOrderId): object;

    public function createDocument(
        string $docType,
        string $customerId,
        ?string $companyId,
        string $currency,
        \Magento\Sales\Model\Order\Address $billingAddress,
        \Magento\Sales\Model\Order\Address $shippingAddress,
        ?string $shippingAgent,
        ?string $shippingService,
        ?string $shippingPickupLocationId,
        string $magentoOrderId,
        string $salesPerson,
        ?string $profitCenter,
        ?string $termsOfDelivery,
        ?string $wayOfDelivery,
        ?string $customerCategory,
        ?string $customerDistrict
    ): \Ecomero\ErpCore\Model\Order\Response;

    public function updateDocument(
        string $docType,
        string $erpId,
        string $magentoOrderId
    ): \Ecomero\ErpCore\Model\Order\Response;

    public function addDocumentItem(
        string $docType,
        string $orderNumber,
        string $erpItemId,
        float $price,
        float $qtyOrdered,
        string $vatCode,
        float $discountAmount,
        float $discountPercent,
        ?string $comment,
        ?string $locationId
    ): void;

    public function postOrder(string $salesOrderId): void;
}
